# REST API для установки/смены пароля



Данное приложение можно разместить в сервере приложений JBoss, который 
устанавливается вместе с Synergy.

## Сборка

Сборка осуществляется при помощи [Gradle Build Tool](https://gradle.org/)

```bash
$ gradle build
```

Собранный `synergy-api-proxy-1.0.war` необходимо поместить 
в `/opt/synergy/jboss/standalone/deployments`

## Конфигурация

1. Приложение читает конфигурационный файл `synergy-api-proxy.properties`
в директории `/opt/synergy/jboss/standalone/configuration/external`.

Параметры конфигурации:

```properties
# Приведенные ниже значения параметров являются значениями по-умолчанию

# Адрес Synergy для доступа к REST API
synergy.url=http://127.0.0.1:8080/Synergy
# Логин пользователя от имени которого будет выполняться запрос к REST API Synergy
synergy.user.login=1
# Пароль пользователя от имени которого будет выполняться запрос к REST API Synergy
synergy.user.password=1
```

2. В файл `/opt/synergy/jboss/standalone/configuration/standalone-onesynergy.xml`, в отдел с datasource добавить следующий код, после чего перезапустить контейнер с синерджи, либо jboss:

```
                <datasource jndi-name="java:jboss/datasources/ml" pool-name="ml" enabled="true" use-java-context="true">
                    <connection-url>jdbc:mysql://127.0.0.1:3306/synergy?useUnicode=true&amp;characterEncoding=utf8</connection-url>
                    <driver>com.mysql.nonxa</driver>
                    <pool>
                        <min-pool-size>20</min-pool-size>
                        <max-pool-size>200</max-pool-size>
                    </pool>
                    <security>
                        <user-name>root</user-name>
                        <password>root</password>
                    </security>
                </datasource>
``` 


## REST API

Endpoint: `http[s]://host:[port]/sap`

1. Метод смены/установки пароля [`POST`]`/proxy/uservice/set_password`

    ```
        /**
         * @param login  - логин пользователя в системе
         * @param new_password - новый пароль пользователя
         */
    ```
    
    Пример запроса:
    
    `http://192.168.4.130:8080/sap/proxy/uservice/set_password?login=1&new_password=123`
