package kz.arta.ext.sap.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.*;

/**
 * Created by val
 * Date: 24.05.2015
 * Time: 17:02
 *
 * Класс для чтения параметров .properties файла
 * Указанный кофигурационный файл ищется в папке jboss/standalone/configuration
 */
public class Config {
    private static final Logger LOGGER = LoggerFactory.getLogger(Config.class);

    private static Properties props = new Properties();

    static {
        File confFile = new File(getConfigDir() + "/external/synergy-api-proxy.properties");
        FileInputStream fis = null;
        Reader isr = null;
        try {
            fis = new FileInputStream(confFile);
            isr = new InputStreamReader(fis, "UTF-8");
            if (confFile.exists()) {
                try {
                    props.load(isr);
                } catch (IOException e) {
                    LOGGER.error("Configuration file not found");
                } finally {
                    
                }
            }
        } catch(FileNotFoundException err) {
            LOGGER.error("File not found");
        } catch (UnsupportedEncodingException e1) {
            LOGGER.error("UnsupportedEncodingException");
        } finally {
            if (null != fis)
            {
                try
                {
                    fis.close();
                }
                catch (Exception e)
                {
                    e.printStackTrace();
                }
            }
            if (null != isr)
            {
                try
                {
                    isr.close();
                }
                catch (Exception e)
                {
                    e.printStackTrace();
                }
            }
        }
    }

    public static String getConfigDir() {
        return System.getProperty("jboss.server.config.dir");
    }

    public static String getProperty(String name, String defaultValue) {
        return props.containsKey(name) ? props.getProperty(name) : defaultValue;
    }
}
