package kz.arta.ext.sap.db;

import org.testng.Assert;

import static org.mockito.Matchers.anyString;
import static org.mockito.Mockito.verify;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import org.mockito.Mockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.testng.annotations.Test;

import kz.arta.ext.sap.service.SynergyUser;
import kz.arta.ext.sap.util.ConnectionPool;

@PrepareForTest({ UserManager.class })
public class UserManagerTest {
	
	/**
	 * Тест на отсутствие соединения с дб
	 * @throws Exception
	 */
	
	@Test
	public void selectFromUsersQueryTest_failConnection() throws Exception {
		ConnectionPool cp = Mockito.mock(ConnectionPool.class);
		Connection con = Mockito.mock(Connection.class);
		
		Mockito.when(cp.getConnection()).thenReturn(con);
		
		SynergyUser su = new SynergyUser();
		su.setError(500);
		
		UserManager um = new UserManager(cp);
		SynergyUser sufunc = um.selectFromUsersQuery("login", "pass", "auth");
		verify(cp).getConnection();
		
		Assert.assertEquals(true, SynergyUser.equals(su, sufunc));		
	}
		
	/**
	 *  Тест на отсутвие пользователя в базе
	 */
	@Test
	public void setPassTest_userNotFound_return404() {
		
		UserManager mockUM = Mockito.mock(UserManager.class);
		UserManager um = new UserManager(null, mockUM);
		
		SynergyUser suNotExist = new SynergyUser(false, false, false, 0);

		Mockito.when(mockUM.selectFromUsersQuery(anyString(), anyString(), anyString())).thenReturn(suNotExist);
		
		Assert.assertEquals(404, um.setPass("login", "new_pass"));
		verify(mockUM).selectFromUsersQuery(anyString(), anyString(), anyString());
	}

	/**
	 *  Тест на успешный запрос в базу
	 */
	@Test
	public void setPassTest_successQuery() {
		ConnectionPool cp = Mockito.mock(ConnectionPool.class);
		Connection con = Mockito.mock(Connection.class);
		PreparedStatement ps = Mockito.mock(PreparedStatement.class);
		ResultSet rs = Mockito.mock(ResultSet.class);
				
		UserManager mockUM = Mockito.mock(UserManager.class);
		UserManager um = new UserManager(cp, mockUM);
		
		SynergyUser suExist = new SynergyUser(true, true, true, 0);

		Mockito.when(mockUM.selectFromUsersQuery(anyString(), anyString(), anyString())).thenReturn(suExist);
		try {
			Mockito.when(cp.getConnection()).thenReturn(con);
			Mockito.when(con.prepareStatement("UPDATE users SET password = MD5( ? ) WHERE login = ? ")).thenReturn(ps);
			Mockito.doNothing().when(ps).setString(1, "new_pass");
			Mockito.doNothing().when(ps).setString(2, "login");
			Mockito.when(ps.executeQuery()).thenReturn(rs);
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		Assert.assertEquals(200, um.setPass("login", "new_pass"));
		verify(mockUM).selectFromUsersQuery(anyString(), anyString(), anyString());
	}
	
	
	/**
	 *  Тест на ошибку 500
	 */
	@Test
	public void setPassTest_error500() {
		ConnectionPool cp = Mockito.mock(ConnectionPool.class);
				
		UserManager mockUM = Mockito.mock(UserManager.class);
		UserManager um = new UserManager(cp, mockUM);
		
		SynergyUser suExist = new SynergyUser(true, true, true, 0);

		Mockito.when(mockUM.selectFromUsersQuery(anyString(), anyString(), anyString())).thenReturn(suExist);
		try {
			Mockito.doThrow(SQLException.class).when(cp).getConnection();
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		Assert.assertEquals(500, um.setPass("login", "new_pass"));
		verify(mockUM).selectFromUsersQuery(anyString(), anyString(), anyString());
	}
	
}

