package kz.arta.ext.sap.service;

import org.testng.Assert;
import org.testng.annotations.Test;

import kz.arta.ext.sap.db.UserManager;

import static org.mockito.Mockito.*;
import static org.testng.Assert.assertEquals;

import java.io.InputStream;

import javax.accessibility.AccessibleRelation;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;

import org.jboss.resteasy.core.Headers;
import org.jboss.resteasy.core.ResourceMethod;
import org.jboss.resteasy.core.ServerResponse;
import org.jboss.resteasy.spi.AsynchronousResponse;
import org.jboss.resteasy.spi.HttpRequest;
import org.mockito.Mockito;
import org.mockito.internal.configuration.injection.filter.MockCandidateFilter;
import org.seleniumhq.jetty9.server.Authentication.User; 


public class SecurityInterceptorTest {
	
	/**
	 *		Обращение к другому методу rest api
	 */
	
	@Test
	public void preProcessTest_anotherMethod() {
		SecurityInterceptor si = new SecurityInterceptor();
		HttpRequest httpReq = Mockito.mock(HttpRequest.class); 
		ResourceMethod resm= Mockito.mock(ResourceMethod.class); 
		
		UriInfo uri = Mockito.mock(UriInfo.class);
		when(httpReq.getUri()).thenReturn(uri);
		when(uri.getPath()).thenReturn("lalala");
		
		ServerResponse serverResp = si.preProcess(httpReq, resm);
		Assert.assertEquals(null, serverResp);
	}
	
	/**
	 * 		Неудачная попытка авторизации
	 */
	
	@Test
	public void preProcessTest_authorizationFailed() {
		UserManager um = Mockito.mock(UserManager.class);
		HttpServletRequest req = Mockito.mock(HttpServletRequest.class);
		SecurityInterceptor secInterp = new SecurityInterceptor(req, um);
		HttpRequest httpRequest = Mockito.mock(HttpRequest.class);
		ResourceMethod resourceMethod = Mockito.mock(ResourceMethod.class);
		UriInfo uriInfo = Mockito.mock(UriInfo.class);
		ServerResponse access_denied = new ServerResponse("{\"status\":\"401 Unauthorized!\", \"errorCode\": \"401\"}", 401, new Headers<Object>());
		
		SynergyUser su = new SynergyUser(false, false, false, 0);
		
		when(httpRequest.getUri()).thenReturn(uriInfo);
		when(uriInfo.getPath()).thenReturn("/uservice/lalala");
		
		when(req.getHeader(anyString())).thenReturn("Basic bG9naW46cGFzc3dvcmQ=");
		when(um.selectFromUsersQuery(anyString(), anyString(), anyString())).thenReturn(su);
		
		ServerResponse sp = secInterp.preProcess(httpRequest, resourceMethod);
		Assert.assertEquals(sp.getStatus(), access_denied.getStatus());
	}
	
	
	/**
	 * 		Ошибка бд при авторизации
	 */
	@Test
	public void preProcessTest_dbError() {
		UserManager um = Mockito.mock(UserManager.class);
		HttpServletRequest req = Mockito.mock(HttpServletRequest.class);
		SecurityInterceptor secInterp = new SecurityInterceptor(req, um);
		HttpRequest httpRequest = Mockito.mock(HttpRequest.class);
		ResourceMethod resourceMethod = Mockito.mock(ResourceMethod.class);
		UriInfo uriInfo = Mockito.mock(UriInfo.class);
		ServerResponse db_error = new ServerResponse("{\"status\":\"Something has gone wrong on serve/db\", \"errorCode\": \"500\"}", 500, new Headers<Object>());
		
		SynergyUser su = new SynergyUser(false, false, false, 500);
		
		when(httpRequest.getUri()).thenReturn(uriInfo);
		when(uriInfo.getPath()).thenReturn("/uservice/lalala");
		
		when(req.getHeader(anyString())).thenReturn("Basic bG9naW46cGFzc3dvcmQ=");
		when(um.selectFromUsersQuery(anyString(), anyString(), anyString())).thenReturn(su);
		
		ServerResponse sp = secInterp.preProcess(httpRequest, resourceMethod);
		Assert.assertEquals(sp.getStatus(), db_error.getStatus());
	}
	
	/**
	 * 		Удачная попытка авторизации
	 */
	
	@Test
	public void preProcessTest_authorizationSuccess() {
		UserManager um = Mockito.mock(UserManager.class);
		HttpServletRequest req = Mockito.mock(HttpServletRequest.class);
		SecurityInterceptor secInterp = new SecurityInterceptor(req, um);
		HttpRequest httpRequest = Mockito.mock(HttpRequest.class);
		ResourceMethod resourceMethod = Mockito.mock(ResourceMethod.class);
		UriInfo uriInfo = Mockito.mock(UriInfo.class);
		@SuppressWarnings("unchecked")
		MultivaluedMap<String, String> mm = Mockito.mock(MultivaluedMap.class);

		SynergyUser su = new SynergyUser(true, true, true, 0);
		
		when(httpRequest.getUri()).thenReturn(uriInfo);
		when(uriInfo.getPath()).thenReturn("/uservice/lalala");
		when(uriInfo.getQueryParameters()).thenReturn(mm);
		Mockito.doNothing().when(mm).add(anyString(), anyString());
		
		when(req.getHeader(anyString())).thenReturn("Basic bG9naW46cGFzc3dvcmQ=");
		when(um.selectFromUsersQuery(anyString(), anyString(), anyString())).thenReturn(su);
				
		secInterp.preProcess(httpRequest, resourceMethod);
	}
	
	
}












