package kz.arta.ext.sap.service;

import org.testng.annotations.Test;

import static org.testng.Assert.assertEquals;

public class SynergyUserTest {

	SynergyUser user = new SynergyUser();
	
	@Test
	public void isAdminTest_false() throws Exception {
		assertEquals(false, user.isAdmin());
	}
	
	
	@Test
	public void setAdminTest_true() throws Exception {
		user.setAdmin(true);
		assertEquals(true, user.isAdmin());
	}
	
	@Test
	public void isAuthTest_false() throws Exception {
		assertEquals(false, user.isAuth());
	}
	
	
	@Test
	public void setAuthTest_true() throws Exception {
		user.setAuth(true);
		assertEquals(true, user.isAuth());
	}
	
	@Test
	public void getErrorTest_0() throws Exception {
		assertEquals(0, user.getError());
	}
	
	
	@Test
	public void setErrorTest_200() throws Exception {
		user.setError(200);
		assertEquals(200, user.getError());
	}
	
	@Test
	public void isExistTest_false() throws Exception {
		assertEquals(false, user.isExist());
	}
	
	
	@Test
	public void isExistTest_true() throws Exception {
		user.setExist(true);
		assertEquals(true, user.isExist());
	}
		
	@Test
	public void equalsTest_returnTrue() {
		SynergyUser su1 = new SynergyUser(false, true, false, 500);
		SynergyUser su2 = new SynergyUser(false, true, false, 500);
		assertEquals(true, SynergyUser.equals(su1, su2));
	}
	
	@Test
	public void equalsTest_returnfalse() {
		SynergyUser su1 = new SynergyUser(true, true, true, 500);
		SynergyUser su2 = new SynergyUser(false, true, false, 500);
		assertEquals(false, SynergyUser.equals(su1, su2));
	}
}
