# Шаблон веб-приложения с кастомным REST API

В приложении приведен пример создания кастомного REST API на Java.

Данное приложение можно разместить в сервере приложений JBoss, который 
устанавливается вместе с Synergy.

## Сборка

Сборка осуществляется при помощи [Gradle Build Tool](https://gradle.org/)

```bash
$ ./gradlew war
```

Собранный `synergy-api-proxy-1.0.war` необходимо поместить 
в `/opt/synergy/jboss/standalone/deployments`

## Конфигурация

Приложение читает конфигурационный файл `synergy-api-proxy.properties`
в директории `/opt/synergy/jboss/standalone/configuration/external`.

Параметры конфигурации:

```properties
# Приведенные ниже значения параметров являются значениями по-умолчанию

# Адрес Synergy для доступа к REST API
synergy.url=http://127.0.0.1:8080/Synergy
# Логин пользователя от имени которого будет выполняться запрос к REST API Synergy
synergy.user.login=1
# Пароль пользователя от имени которого будет выполняться запрос к REST API Synergy
synergy.user.password=1
```

## REST API

Endpoint: `http[s]://host:[port]/sap`

1. Метод получения изображения [`GET`]`/proxy/unsecured/image`

    ```
        /**
         * Обертка над методом /rest/api/storage/file/get
         * Не требует авторизации.
         * Обращение к REST API Synergy осуществляется от имени пользователя,
         * указанного в настройках (параметры synergy.user.login и synergy.user.password)
         *
         * @param identifier идентификатор файла в хранилище
         * @return inline изображение. Если запрошенный файл не является изображением, то вернется ошибка.
         */
    ```
    
    Пример запроса:
    
    `http://127.0.0.1:8080/sap/proxy/unsecured/image?identifier=29130a30-42cf-451a-98e8-6f6827d3751b`