package kz.arta.ext.sap.db;

import kz.arta.ext.sap.util.ConnectionPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.naming.NamingException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

/**
 * Created by val
 * Date: 04.10.2015
 * Time: 12:49
 *
 * Пример класса для работы с СУБД
 * использует соединение, указанное в @{@link ConnectionPool}
 */
public class ClientManager {

    private static final Logger LOGGER = LoggerFactory.getLogger(ClientManager.class);

    public static void log(Object logItem) {
        Connection con = null;
        try {
            con = ConnectionPool.getConnection();

            PreparedStatement st = con.prepareStatement("INSERT INTO log(logged, clientid, hostname, extip, localip) VALUES (CURRENT_TIMESTAMP, ?, ?, ?, ?)");

            st.setString(1, "clientId");
            st.setString(2, "hostname");
            st.setString(3, "extip");
            st.setString(4, "localip");

            st.execute();

        } catch (SQLException | NamingException e) {
            LOGGER.error("", e);
        } finally {
            ConnectionPool.close(con);
        }
    }
}
