package kz.arta.ext.sap.service;

import kz.arta.ext.sap.util.Config;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHeaders;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.enterprise.context.RequestScoped;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import java.io.IOException;
import java.nio.charset.Charset;

/**
 * Created by val
 * Date: 04.10.2015
 * Time: 11:27
 *
 * REST сервис с методами, которые не требуют авторизации
 */
@Path("/unsecured")
@RequestScoped
public class UnsecuredProxyService {

    private static final Logger LOGGER = LoggerFactory.getLogger(UnsecuredProxyService.class);

    @GET
    @Path("/test")
    @Produces(MediaType.APPLICATION_JSON + "; charset=utf-8")
    public String test() {
        return "{\"status\":\"working\"}";
    }

    /**
     * Обертка над методом /rest/api/storage/file/get
     * Не требует авторизации.
     * Обращение к REST API Synergy осуществляется от имени пользователя,
     * указанного в настройках (параметры synergy.user.login и synergy.user.password)
     *
     * @param identifier идентификатор файла в хранилище
     * @return inline изображение. Если запрошенный файл не является изображением, то вернется ошибка.
     */
    @GET
    @Path("/image")
    public Response getImage(@QueryParam("identifier") String identifier) {

        try {

            String auth = Config.getProperty("synergy.user.login", "1") + ":" + Config.getProperty("synergy.user.password", "1");
            byte[] encodedAuth = Base64.encodeBase64(
                    auth.getBytes(Charset.forName("UTF-8")));
            String authHeader = "Basic " + new String(encodedAuth);

            CloseableHttpClient client = HttpClientBuilder.create().build();

            HttpGet request = new HttpGet(Config.getProperty("synergy.url", "http://127.0.0.1:8080/Synergy") +
                    "/rest/api/storage/file/get?inline=true&identifier=" + identifier);
            request.setHeader(HttpHeaders.AUTHORIZATION, authHeader);

            HttpResponse response = client.execute(request);
            HttpEntity entity = response.getEntity();

            int responseCode = response.getStatusLine().getStatusCode();

            LOGGER.info("Request Url: " + request.getURI());
            LOGGER.info("Response Code: " + responseCode);
            LOGGER.info("Content-Type: " + entity.getContentType().getValue());

            if (entity.getContentType().getValue().toLowerCase().startsWith("image/png")) {

                Response.ResponseBuilder builder = Response.ok();
                builder.entity(entity.getContent());

                for (Header header : response.getAllHeaders()) {
                    builder.header(header.getName(), header.getValue());
                }

                return builder.build();
            } else {
                return Response.status(Response.Status.BAD_REQUEST).entity("Not an image").build();
            }

        } catch (IOException e) {
            LOGGER.error("", e);
            return Response.serverError().build();
        }

    }

}
