package kz.arta.ext.sap.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.*;

/**
 * Created by val
 * Date: 24.05.2015
 * Time: 17:02
 *
 * Класс для чтения параметров .properties файла
 * Указанный кофигурационный файл ищется в папке jboss/standalone/configuration
 */
public class Config {
    private static final Logger LOGGER = LoggerFactory.getLogger(Config.class);

    private static Properties props = new Properties();

    static {
        File confFile = new File(getConfigDir() + "/external/synergy-api-proxy.properties");
        if (confFile.exists()) {
            try {
                props.load(new InputStreamReader(new FileInputStream(confFile), "UTF8"));
            } catch (IOException e) {
                LOGGER.error("Configuration file not found");
            }
        }
    }

    public static URL getResource(String path) {
        return Config.class.getResource(path);
    }

    public static String getConfigDir() {
        return System.getProperty("jboss.server.config.dir");
    }

    public static String getProperty(String name, String defaultValue) {
        return props.containsKey(name) ? props.getProperty(name) : defaultValue;
    }

    public static int getIntProperty(String name, int defaultValue) {
        if (props.containsKey(name)) {
            int value = defaultValue;
            String v = props.getProperty(name);
            try {
                value = Integer.parseInt(v);
            } catch (NumberFormatException e) {
                LOGGER.error("Invalid type of value '" + v + "' for property '" + name + "'. Integer type required.");
            }
            return value;
        } else
            return defaultValue;
    }

    public static double getDoubleProperty(String name, double defaultValue) {
        if (props.containsKey(name)) {
            double value = defaultValue;
            String v = props.getProperty(name);
            try {
                value = Double.parseDouble(v);
            } catch (NumberFormatException e) {
                LOGGER.error("Invalid type of value '" + v + "' for property '" + name + "'. Double type required.");
            }
            return value;
        } else
            return defaultValue;
    }

    public static boolean getBooleanProperty(String name, boolean defaultValue) {
        if (props.containsKey(name)) {
            boolean value = defaultValue;
            String v = props.getProperty(name);
            try {
                value = Boolean.parseBoolean(v);
            } catch (Exception e) {
                LOGGER.error("Invalid type of value '" + v + "' for property '" + name + "'. Boolean type required.");
            }
            return value;
        }
        return defaultValue;
    }

    public static List<String> getPropertyList(String mask, String[] defaultValue) {
        List<String> list = new ArrayList<String>();
        for (String property : props.stringPropertyNames()) {
            if (property.startsWith(mask)) {
                list.add(property.substring(property.lastIndexOf(".") + 1));
            }
        }
        return list.size() > 0 ? list : Arrays.asList(defaultValue);
    }

    public static Map<String, String> getPropertyList(String mask) {
        Map<String, String> map = new HashMap<String, String>();
        for (String property : props.stringPropertyNames()) {
            if (property.startsWith(mask)) {
                map.put(property, props.getProperty(property));
            }
        }
        return map;
    }
}
