package kz.arta.ext.sap.db;

import kz.arta.ext.sap.service.SynergyUser;
import kz.arta.ext.sap.util.ConnectionPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.naming.NamingException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.ResultSet;

/**
 * Created by val
 * Date: 04.10.2015
 * Time: 12:49
 *
 * Modified: 06.2018
 * работа с СУБД
 * использует соединение, указанное в @{@link ConnectionPool}
 **/

public class UserManager {	
    private static final Logger LOGGER = LoggerFactory.getLogger(UserManager.class);
    private static final String IS_ADMIN = "isadmin";
    private static final String IS_AUTH = "isauth";
    
    /**
     * 
     * @param login  Логин пользователя, которому требуется сменить/установить пароль
     * @param new_pass  Новый пароль
     * @return  Возвращает 200 - в случае успешной смены пароля, 500 - в случае возникновения каких-либо ошибок с базой данных.
     */
    
    public static int setPass(String login, String new_pass) {
    	if(UserManager.dbInteraction(login, null, "isExist").getisExist()) {
	    		    	
			Connection con = null;
			PreparedStatement updatePassword = null;
	        try {
	            con = ConnectionPool.getConnection();
				updatePassword = con.prepareStatement("UPDATE users SET password = MD5( ? ) WHERE login = ? ");
				updatePassword.setString(1, new_pass);
				updatePassword.setString(2, login);
				updatePassword.executeUpdate();
				return 200; 
	
	        } catch (SQLException | NamingException e) {
	            LOGGER.error("", e);
				return 500; 
	        } finally {
	        	if(updatePassword != null) {
		        	try {
						updatePassword.close();
					} catch (SQLException e) {
			            LOGGER.error("", e);
						return 500; 
					}
	        	}
	            ConnectionPool.close(con);
	        }
    	} else return 404;
    }
	
	/**
	 * 
	 * @param login           Логин пользователя
	 * @param field           Поле для поиска записей в базе
	 * @param value           Значение, по которому нужно искать
	 * @param requestType     Может принимать значения "isadmin", "isauth", или любое другое для проверки существования пользователя; 
	 * @return                Объект класса SynergyUser
	 */
    
	public static SynergyUser dbInteraction(String login, String value, String requestType) {
		Connection con = null;
		PreparedStatement ps = null;
		ResultSet rs = null;
		SynergyUser user = new SynergyUser();
		
        try {
            con = ConnectionPool.getConnection();
            
        	if(requestType.equals(IS_AUTH)) {
        		ps = con.prepareStatement("SELECT * FROM users WHERE login = ? AND password = md5( ? )");
                ps.setString(2, value);
        	} else if(requestType.equals(IS_ADMIN)){
        		ps = con.prepareStatement("SELECT * FROM users WHERE login = ? AND isadmin = 1");
        	} else ps = con.prepareStatement("SELECT * FROM users WHERE login = ? ");
        	
            ps.setString(1, login);
        
			rs = ps.executeQuery();
			
			if(rs.next()) {
				if(requestType.equals(IS_AUTH)){
					user.setIsAuth(true);
				} else if(requestType.equals(IS_ADMIN)) {
					user.setIsAdmin(true);
					user.setIsAuth(true);
				} else {
					user.setExist(true);
				}
			} 
			
			return user;

        } catch (SQLException | NamingException e) {
            LOGGER.error("", e);
            user.setIsError(500);
			return user; 
        } finally {
        	if(rs != null) {
	           	try {
					rs.close();
				} catch (SQLException e) {
		            LOGGER.error("", e);
				}
        	}
        	if(ps != null) {
	        	try {
					ps.close();
				} catch (SQLException e) {
		            LOGGER.error("", e);
				}
        	}
            ConnectionPool.close(con);
        }
        
	}
	
}














