package kz.arta.ext.sap.db;

import kz.arta.ext.sap.util.ConnectionPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.naming.NamingException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.ResultSet;

/**
 * Created by val
 * Date: 04.10.2015
 * Time: 12:49
 *
 * Modified: 06.2018
 * работа с СУБД
 * использует соединение, указанное в @{@link ConnectionPool}
 **/

public class UserManager {

    private static final Logger LOGGER = LoggerFactory.getLogger(UserManager.class);
    
    public static int ifUserExist(String login) {
		Connection con = null;
		ResultSet res = null;
		PreparedStatement chechExistance = null;
        try {
            con = ConnectionPool.getConnection();
            chechExistance = con.prepareStatement("SELECT * FROM users WHERE login = ? ");
			chechExistance.setString(1, login);
			res = chechExistance.executeQuery();
			
			if(res.next()) {
				return 200;
			}
			else return 404;

        } catch (SQLException | NamingException e) {
            LOGGER.error("", e);
			return 500; 
        } finally {
        	if (res != null) {
	        	try {
					res.close();
				} catch (SQLException e) {
					e.printStackTrace();
				}
        	}
        	if (chechExistance != null) {
	        	try {
					chechExistance.close();
				} catch (SQLException e) {
					e.printStackTrace();
				}
        	}
            ConnectionPool.close(con);
        }
    }

    public static int setPass(String login, String new_pass) {
    	if(UserManager.ifUserExist(login) == 200) {
	    		    	
			Connection con = null;
			PreparedStatement updatePassword = null;
	        try {
	            con = ConnectionPool.getConnection();
				updatePassword = con.prepareStatement("UPDATE users SET password = MD5( ? ) WHERE login = ? ");
				updatePassword.setString(1, new_pass);
				updatePassword.setString(2, login);
				updatePassword.executeUpdate();
				return 200; 
	
	        } catch (SQLException | NamingException e) {
	            LOGGER.error("", e);
				return 500; 
	        } finally {
	        	if(updatePassword != null) {
		        	try {
						updatePassword.close();
					} catch (SQLException e) {
			            LOGGER.error("", e);
						return 500; 
					}
	        	}
	            ConnectionPool.close(con);
	        }
    	} else return 404;
    }
	
	public static int checkAuth(String login, String password) {
		Connection con = null;
		PreparedStatement searchUser = null;
		ResultSet rs = null;
        try {
            con = ConnectionPool.getConnection();
			searchUser = con.prepareStatement("SELECT * FROM users WHERE login = ? AND password = md5(?)");
			searchUser.setString(1, login);
			searchUser.setString(2, password);
			rs = searchUser.executeQuery();
			
			if(rs.next()) {
				return 200;
			}
			
			return 401;

        } catch (SQLException | NamingException e) {
            LOGGER.error("", e);
			return 500; 
        } finally {
        	if(rs != null) {
	        	try {
					rs.close();
				} catch (SQLException e) {
		            LOGGER.error("", e);
				}
        	}
        	if(searchUser != null) {
	        	try {
					searchUser.close();
				} catch (SQLException e) {
		            LOGGER.error("", e);
				}
        	}
            ConnectionPool.close(con);
        }	
    }
	
	public static int isAdmin(String login) {
		Connection con = null;
		PreparedStatement isAdminCheck = null;
		ResultSet rs = null;
        try {
            con = ConnectionPool.getConnection();
			isAdminCheck = con.prepareStatement("SELECT * FROM users WHERE login = ? AND isadmin = 1");
			isAdminCheck.setString(1, login);
			rs = isAdminCheck.executeQuery();
			
			if(rs.next()) {
				return 1;
			}
			
			return 0;

        } catch (SQLException | NamingException e) {
            LOGGER.error("", e);
			return 500; 
        } finally {
        	if(rs != null) {
	           	try {
					rs.close();
				} catch (SQLException e) {
		            LOGGER.error("", e);
				}
        	}
        	if(isAdminCheck != null) {
	        	try {
					isAdminCheck.close();
				} catch (SQLException e) {
		            LOGGER.error("", e);
				}
        	}
            ConnectionPool.close(con);
        }
    }
}
