package kz.arta.ext.sap.service;


import org.jboss.resteasy.annotations.interception.Precedence;
import org.jboss.resteasy.annotations.interception.ServerInterceptor;
import org.jboss.resteasy.core.Headers;
import org.jboss.resteasy.core.ResourceMethod;
import org.jboss.resteasy.core.ServerResponse;
import org.jboss.resteasy.spi.Failure;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.interception.PreProcessInterceptor;

import kz.arta.ext.sap.db.UserManager;
import sun.misc.BASE64Decoder;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.ext.Provider;

/**
 * Created by val
 * Date: 17.04.2014
 * Time: 18:51
 *
 * Обработчик доступа к методам REST API
 */
@Provider
@ServerInterceptor
@Precedence("SECURITY")
public class SecurityInterceptor implements PreProcessInterceptor {

    private static final ServerResponse ACCESS_DENIED = new ServerResponse("{\"status\":\"401 Unauthorized!\", \"errorCode\": \"401\"}", 401, new Headers<Object>());
    private static final ServerResponse DB_ERROR = new ServerResponse("{\"status\":\"Something has gone wrong on serve/db\", \"errorCode\": \"500\"}", 500, new Headers<Object>());

    
    @Context
    HttpServletRequest request;

    @Context
    HttpServletResponse response;

    @Override
    public ServerResponse preProcess(HttpRequest httpRequest, ResourceMethod resourceMethod) throws Failure, WebApplicationException {
    	String currentUserLogin = null;
    	
    	if (httpRequest.getUri().getPath().startsWith("/uservice/")){
    		String authParam = request.getHeader("Authorization");
    		
    		String decodedAuth = "";
    		String[] authParts = authParam.split(" ");
    		String authInfo = authParts[1];
    		
    		byte[] bytes = null;
    		 try {
                bytes = new BASE64Decoder().decodeBuffer(authInfo);
                decodedAuth = new String(bytes, "UTF-8");
            } catch (IOException e) {
                e.printStackTrace();
            }

    		String[] authArray = decodedAuth.split(":");

    		currentUserLogin = authArray[0];
    		String currentUserPass = authArray[1];
    	
    		int authResult = UserManager.checkAuth(currentUserLogin, currentUserPass);
    		if (authResult == 401){
    			return ACCESS_DENIED;
    		} else if (authResult == 500){
    			return DB_ERROR;
    		}
    			
    		httpRequest.getUri().getQueryParameters().add("currentUserLogin", currentUserLogin);    			
    	}

    	return null;
    }
}
