package kz.arta.ext.sap.db;

import kz.arta.ext.sap.service.SynergyUser;
import kz.arta.ext.sap.util.ConnectionPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.naming.NamingException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.ResultSet;

/**
 * Created by val
 * Date: 04.10.2015
 * Time: 12:49
 *
 * Modified: 06.2018
 * работа с СУБД
 * использует соединение, указанное в @{@link ConnectionPool}
 **/

public class UserManager {	
    private static final Logger LOGGER = LoggerFactory.getLogger(UserManager.class);
    private static final String AUTH = "auth";
    private static final String EXIST = "exist";
    private static final String ISADMIN = "isadmin";
    
    /**
     * 
     * @param login  Логин пользователя, которому требуется сменить/установить пароль
     * @param new_pass  Новый пароль
     * @return  Возвращает 200 - в случае успешной смены пароля, 500 - в случае возникновения каких-либо ошибок с базой данных.
     */
    
    public static int setPass(String login, String new_pass) {
    	if(UserManager.selectFromUsersQuery(login, null, "exist").isExist()) {
	    		    	
			Connection con = null;
			PreparedStatement updatePassword = null;
	        try {
	            con = ConnectionPool.getConnection();
				updatePassword = con.prepareStatement("UPDATE users SET password = MD5( ? ) WHERE login = ? ");
				updatePassword.setString(1, new_pass);
				updatePassword.setString(2, login);
				updatePassword.executeUpdate();
				return 200; 
	
	        } catch (SQLException | NamingException e) {
	            LOGGER.error("", e);
				return 500; 
	        } finally {
	        	if(updatePassword != null) {
		        	try {
						updatePassword.close();
					} catch (SQLException e) {
			            LOGGER.error("", e);
						return 500; 
					}
	        	}
	            ConnectionPool.close(con);
	        }
    	} else return 404;
    }
	
	/**
	 * 
	 * @param login           Логин пользователя
	 * @param value           Значение, по которому нужно искать
	 * @param requestType     Может принимать значения "auth", или "exist"; 
	 * @return                Объект класса SynergyUser
	 */
    
	public static SynergyUser selectFromUsersQuery(String login, String value, String requestType) {
		Connection con = null;
		PreparedStatement ps = null;
		ResultSet rs = null;
		SynergyUser user = new SynergyUser();
		
        try {
            con = ConnectionPool.getConnection();
            
        	if(requestType.equals(AUTH)) {
        		
        		ps = con.prepareStatement("SELECT * FROM users WHERE login = ? AND password = md5( ? )");
                ps.setString(2, value);

        	} else if(requestType.equals(EXIST)){
        		ps = con.prepareStatement("SELECT * FROM users WHERE login = ?");
        		ps.setString(1, login);
        	}
        	
    		ps.setString(1, login);
			rs = ps.executeQuery();
        	
			if(rs.next()) {
				
				user.setAdmin(rs.getBoolean(ISADMIN));
				user.setAuth(true);
				user.setExist(true);
				
			} 
			
			return user;

        } catch (SQLException | NamingException e) {
            LOGGER.error("", e);
            user.setError(500);
			return user; 
        } finally {
        	if(rs != null) {
	           	try {
					rs.close();
				} catch (SQLException e) {
		            LOGGER.error("", e);
				}
        	}
        	if(ps != null) {
	        	try {
					ps.close();
				} catch (SQLException e) {
		            LOGGER.error("", e);
				}
        	}
            ConnectionPool.close(con);
        }
        
	}
	
}

