package kz.arta.ext.sap.service;

import kz.arta.ext.sap.db.UserManager;

import javax.enterprise.context.RequestScoped;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;


/**
 * Created by val
 * Date: 04.10.2015
 * Time: 11:27
 *
 * Modified
 * Date: 06.2018
 * REST API метод для смены/установки пароля
 */

@Path("/uservice")
@RequestScoped
public class PasswordSetService {

    @GET
    @Path("/test")
    @Produces(MediaType.APPLICATION_JSON + "; charset=utf-8")
    public String test() {
        return "{\"status\":\"working\"}";
    }
    
    /**
     * 
     * @param authParam header  Параметр авторизации Basic Auth
     * @param currentUserLogin  Логин пользователя, который делает запрос
     * @param login  Логин пользователя, которому нужно поменять/установить пароль
     * @param new_pass  Новыйй пароль
     * 
     */
	
	@POST
	@Path("/set_password")
	@Produces(MediaType.APPLICATION_JSON + "; charset=utf-8")
    public String setPassword(@HeaderParam("authorization") String authParam, @QueryParam("currentUserLogin") String currentUserLogin, @QueryParam("currentUserPass") String currentUserPass, @QueryParam("login") String login, @QueryParam("new_password") String new_pass){
		try {
			boolean su = UserManager.selectFromUsersQuery(currentUserLogin, currentUserPass, "auth").isAdmin();
			
			if(su) {
				
				return PasswordSetService.errorMessagesHandler(UserManager.setPass(login, new_pass));
			
			} else {
				
				if( login.equals(currentUserLogin)) return PasswordSetService.errorMessagesHandler(UserManager.setPass(login, new_pass));
				else return PasswordSetService.errorMessagesHandler(403);
			
			}
			
		} catch (RuntimeException e) {
		    throw e;
		} catch (Exception e) {
			return "Error: " + e;
		}
    }
	
	public static String errorMessagesHandler(int code) {
		switch(code) {
			case 200: return "{\"result\":\"success\", \"errorCode\":\"0\"}";
			case 401: return "{\"status\":\"401 Unauthorized!\", \"errorCode\": \"401\"}"; 
			case 403: return "{\"status\":\"403 Forbidden.\", \"error\":\"You don't have any access to the requested account\", \"errorCode\": \"403\"}";
			case 404: return "{\"status\":\"There is no user with such login!\", \"errorCode\": \"404\"}";
			default: return "{\"status\":\"Something has gone wrong on serve/db\", \"errorCode\": \"500\"}";
		}
	}
}
