package kz.arta.ext.sap.service;

import kz.arta.ext.sap.util.SubsidiaryLib;

import javax.enterprise.context.RequestScoped;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;



/**
 * Created by val
 * Date: 04.10.2015
 * Time: 11:27
 *
 * Modified
 * Date: 06.2018
 * REST API метод для смены/установки пароля
 */

@Path("/uservice")
@RequestScoped
public class UnsecuredProxyService {

    @GET
    @Path("/test")
    @Produces(MediaType.APPLICATION_JSON + "; charset=utf-8")
    public String test() {
        return "{\"status\":\"working\"}";
    }
	
	@POST
	@Path("/set_password")
	@Produces(MediaType.APPLICATION_JSON + "; charset=utf-8")
    public String setPassword(@HeaderParam("authorization") String authParam, @QueryParam("login") String login, @QueryParam("new_password") String new_pass){
		return SubsidiaryLib.checkTheAccess(authParam, login, new_pass);
    }
	
}
