package kz.arta.ext.sap.db;

import kz.arta.ext.sap.util.ConnectionPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.naming.NamingException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.ResultSet;

/**
 * Created by val
 * Date: 04.10.2015
 * Time: 12:49
 *
 * Modified: 06.2018
 * работа с СУБД
 * использует соединение, указанное в @{@link ConnectionPool}
 */
public class UserManager {

    private static final Logger LOGGER = LoggerFactory.getLogger(UserManager.class);
    
    public static int ifUserExist(String login) {
		Connection con = null;
        try {
            con = ConnectionPool.getConnection();
			PreparedStatement chechExistance = con.prepareStatement("SELECT * FROM users WHERE login = ? ");
			chechExistance.setString(1, login);
			ResultSet res = chechExistance.executeQuery();
			
			int columns = res.getMetaData().getColumnCount();
			StringBuilder message = new StringBuilder();
			
			while (res.next()) {
				for (int i = 1; i <= columns; i++){
					message.append(res.getString(i) + " ");
				}
			}	
			
			if(message.toString().length() > 0) return 200;
			else return 404;

        } catch (SQLException | NamingException e) {
            LOGGER.error("", e);
			return 500; 
        } finally {
            ConnectionPool.close(con);
        }
    }

    public static int setPass(String login, String new_pass) {
    	if(UserManager.ifUserExist(login) == 200) {
	    		    	
			Connection con = null;
	        try {
	            con = ConnectionPool.getConnection();
				PreparedStatement updatePassword = con.prepareStatement("UPDATE users SET password = MD5( ? ) WHERE login = ? ");
				updatePassword.setString(1, new_pass);
				updatePassword.setString(2, login);
				updatePassword.executeUpdate();
				return 200; 
	
	        } catch (SQLException | NamingException e) {
	            LOGGER.error("", e);
				return 500; 
	        } finally {
	            ConnectionPool.close(con);
	        }
    	} else return 404;
    }
	
	public static int checkAuth(String login, String password) {
		Connection con = null;
        try {
            con = ConnectionPool.getConnection();
			PreparedStatement searchUser = con.prepareStatement("SELECT * FROM users WHERE login = ? AND password = md5(?)");
			searchUser.setString(1, login);
			searchUser.setString(2, password);
			ResultSet rs = searchUser.executeQuery();
			int columns = rs.getMetaData().getColumnCount();
			StringBuilder message = new StringBuilder();
			
			while (rs.next()) {
				for (int i = 1; i <= columns; i++){
					message.append(rs.getString(i) + " ");
				}
			}	
			
			if(message.toString().length() > 0) return 200;
			
			return 401;

        } catch (SQLException | NamingException e) {
            LOGGER.error("", e);
			return 500; 
        } finally {
            ConnectionPool.close(con);
        }	
    }
	
	public static int isAdmin(String login) {
		Connection con = null;
        try {
            con = ConnectionPool.getConnection();
			PreparedStatement isAdminCheck = con.prepareStatement("SELECT * FROM users WHERE login = ? AND isadmin = 1");
			isAdminCheck.setString(1, login);
			ResultSet rs = isAdminCheck.executeQuery();
			int columns = rs.getMetaData().getColumnCount();
			StringBuilder message = new StringBuilder();
			
			while (rs.next()) {
				for (int i = 1; i <= columns; i++){
					message.append(rs.getString(i) + " ");
				}
			}	
			
			if(message.toString().length() > 0) return 1;
			
			return 0;

        } catch (SQLException | NamingException e) {
            LOGGER.error("", e);
			return 500; 
        } finally {
            ConnectionPool.close(con);
        }	
    }
}
