# Инструкция по использованию

1. Остановить jboss

    ```
     # /etc/init.d/arta-synergy-jboss stop
    ```

2. Результат сборки `build/libs/blocking-process-template-1.0.war` положить в `/opt/synergy/jboss/standalone/deployments`

3. Создать очередь JMS для блокирующего процесса. 
   Для этого необходимо в конфигурационный файл 
   (в стандартной установке это `/opt/synergy/jboss/standalone/configuration/standalone-onesynergy.xml`) 
   в секцию <subsystem xmlns="urn:jboss:domain:messaging:1.2"> раздел `<jms-destinations>` добавить:

    ```xml
    <jms-queue name="BlockingProcessTemplate">
        <entry name="queue/BlockingProcessTemplateQueue"/>
        <entry name="java:jboss/exported/jms/queue/BlockingProcessTemplateQueue"/>
        <durable>true</durable>
    </jms-queue>
    ```

4. Связать очередь и процесс через конфигурационный файл `/opt/synergy/jboss/standalone/configuration/arta/api-observation-configuration.xml`, 
   добавив в него следующее:
   
    ```xml
    <listener>
      <queue>java:jboss/exported/jms/queue/BlockingProcessTemplateQueue</queue>
      <event>event.blocking.template</event>
    </listener>
    ```
    Если конфигурационного файла `api-observation-configuration.xml` нет, то необходимо его создать и указать владельца:
   
    ```
     # chown jboss:synergy api-observation-configuration.xml
    ```
   
    Его содержимое должно быть следующим:
   
    ```xml
     <?xml version="1.0"?>
     <configuration>
       <listener>
         <queue>java:jboss/exported/jms/queue/BlockingProcessTemplateQueue</queue>
         <event>event.blocking.template</event>
       </listener>
     </configuration>
    ```

5. Запустить jboss

    ```
     # /etc/init.d/arta-synergy-jboss start
    ```

6. В маршруте реестра добавить блокирующий процесс `event.blocking.template`
