package kz.arta.ext;


import kz.arta.ext.rest.SynergyAPI;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;

@MessageDriven(name = "BlockingProcessTemplateListener", activationConfig = {
        @ActivationConfigProperty(propertyName = "destinationType", propertyValue = "javax.jms.Queue"),
        @ActivationConfigProperty(propertyName = "destination", propertyValue = "queue/BlockingProcessTemplateQueue"),
        @ActivationConfigProperty(propertyName = "acknowledgeMode", propertyValue = "Auto-acknowledge")
})
public class MessageListenerTemplate implements MessageListener {

    private static final Logger LOGGER = LoggerFactory.getLogger(MessageListenerTemplate.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();

    @Override
    public void onMessage(Message message) {
        LOGGER.info("message received: " + message.toString());

        if (!(message instanceof TextMessage)) {
            return;
        }

        SynergyMessage synergyMessage = new SynergyMessage();

        try {
            // получим текст сообщения, которое нам пришло
            String msg = ((TextMessage) message).getText();
            LOGGER.info("message received: " + msg);

            // сообщение приходит в виде JSON строки,
            // преобразуем его в объект, чтобы было удобнее работать
            synergyMessage = MAPPER.readValue(msg, SynergyMessage.class);

            /**
             * Здесь необходимо реализовать бизнес-логику блокирующего процесса
             */

            // если бизнес-логика отрабатывает очень быстро, то необходимо поставить небольшую задержку
            // перед завершением блокирующего процесса
            Thread.sleep(3000);

            // по завершению выполнения блокирующего процесса необходимо отправить результат обратно в Synergy
            SynergyAPI.signalProcess("got_agree", synergyMessage.getExecutionID(), "Успешно");

        } catch (Exception e) {
            LOGGER.error(e.getMessage(), e);
            // при возникновении ошибки в Synergy передаем соответствующий результат
            SynergyAPI.signalProcess("got_refuse", synergyMessage.getExecutionID(), "Неуспешно");
        }

    }
}
