package kz.arta.ext.rest;

import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;

public class SynergyAPI {

    private static final Logger LOGGER = LoggerFactory.getLogger(SynergyAPI.class);

    private static String address = "http://127.0.0.1:8080/Synergy/rest/api";
    private static String login = "user";
    private static String password = "user";


    public static void signalProcess(String signal, String executionID, String comment) {

        try {
            URL url = new URL(address + "/processes/signal?signal=" + signal + "&executionID=" + executionID + "&param1=resolution&value1=" + URLEncoder.encode(comment, "UTF-8"));
            LOGGER.info("[API.REQ] " + url.toString());
            HttpURLConnection conn = (HttpURLConnection) url.openConnection();
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Accept", "application/json; charset=utf-8");

            String encoded = Base64.encode((login + ":" + password).getBytes());
            conn.setRequestProperty("Authorization", "Basic " + encoded);

            String output;
            StringBuilder result = new StringBuilder();

            BufferedReader br = new BufferedReader(new InputStreamReader((conn.getInputStream())));

            while ((output = br.readLine()) != null) {
                result.append(output);
            }

            conn.disconnect();

            LOGGER.info("[API.RESP] " + result.toString());

        } catch (Exception exc) {
            LOGGER.error(exc.getMessage(), exc);
        }
    }

}
