const getContentFromForm = async (uuid, run, parentContainer) => {
  const container = $('<div>', {style: 'width: 100%; overflow: hidden;'});
  if(parentContainer) {
    container.css('height', '100%');
  } else {
    container.css('height', 'calc(100% - 40px)');
  }

  let editable = false;
  const buttonsPanel = $('<div>', {class: 'wf-form-buttons-panel'});
  const playerContainer = $('<div>', {class: 'wf-form-player-container'});
  const player = UTILS.getSynergyPlayer(uuid, false);
  const buttonSave = $('<span class="material-icons wf-icons" style="display: none;">save</span>');
  const buttonPrint = $('<span class="material-icons wf-icons">print</span>');
  const buttonEditable = $('<span class="material-icons wf-icons">edit</span>');
  const buttonActivate = $('<button>', {class: "uk-button uk-button-primary uk-button-small uk-hidden"});

  if(run) {
    buttonActivate.text(run.label);
    buttonActivate.removeClass('uk-hidden');
  }

  player.view.container.css({'background': '#fff'});
  playerContainer.append(player.view.container);

  buttonSave.on('click', e => {
    if(!player.model.hasChanges) return;
    Cons.showLoader();
    if(!player.model.isValid()) {
      showMessage(i18n.tr('Заполните обязательные поля'), 'error');
      Cons.hideLoader();
    } else {
      player.saveFormData(result => {
        showMessage(i18n.tr('Данные сохранены'), 'success');
        if(!run) appAPI.modifyDoc(player.model.asfDataId);
        Cons.hideLoader();
      });
    }
  });

  buttonActivate.on('click', e => {
    Cons.showLoader();
    if(!player.model.isValid()) {
      showMessage(i18n.tr('Заполните обязательные поля'), 'error');
      Cons.hideLoader();
    } else {
      player.saveFormData(async result => {
        await appAPI.activateDoc(player.model.asfDataId);
        showMessage(i18n.tr('Данные сохранены'), 'success');

        editable = false;
        player.view.setEditable(editable);
        buttonEditable.text('edit');
        buttonPrint.show();
        if(player.model.hasChanges) {
          buttonSave.show();
        } else {
          buttonSave.hide();
        }

        buttonActivate.addClass('uk-hidden');

        Cons.hideLoader();
      });
    }
  });

  buttonPrint.on('click', e => {
    if(player.model.hasPrintable) {
      window.open(`../Synergy/rest/asforms/template/print/form?format=pdf&dataUUID=${uuid}`);
    } else {
      UTILS.printForm(player.view.container[0]);
    }
  });

  buttonEditable.on('click', e => {
    editable = !editable;
    player.view.setEditable(editable);
    if(editable) {
      buttonEditable.text('description');
      buttonPrint.hide();
      buttonSave.show();
    } else {
      buttonEditable.text('edit');
      buttonPrint.show();
      if(player.model.hasChanges) {
        buttonSave.show();
      } else {
        buttonSave.hide();
      }
    }
  });

  buttonsPanel.append(
    $('<div>').append(buttonSave, buttonPrint, buttonActivate),
    $('<div>').append(buttonEditable)
  );

  container.append(buttonsPanel, playerContainer);
  return {container, player};
}

this.openFormPlayer = async (uuid, parentContainer = null, closeDialogHandler) => {
  Cons.showLoader();
  const documentID = await AS.FORMS.ApiUtils.getDocumentIdentifier(uuid);
  const docActions = await AS.FORMS.ApiUtils.simpleAsyncGet(`rest/api/docflow/document_actions?documentID=${documentID}&locale=${AS.OPTIONS.locale}`);
  const run = docActions.find(x => x.operation == 'RUN');

  const meaning = await appAPI.getDocMeaningContent(uuid) || 'Документ';
  const {container: body, player} = await getContentFromForm(uuid, run, parentContainer);

  if(parentContainer) {
    parentContainer.empty();
    parentContainer.append(body);
  } else {
    const dialog = UTILS.getFullModalDialog(meaning, body);
    UIkit.modal(dialog).show();
    dialog.on('hidden', () => {
      dialog.remove();
      if(closeDialogHandler && player.model.hasChanges) closeDialogHandler();
    });
  }
  Cons.hideLoader();
}
