# Дополнительная кнопка реестра

**Автор**: [Валентин Скрипников](mailto:v.skripnikov@arta.pro)

Компонент представляет собой объект `RegistryToolbarButtonExt` инциализация которого добавляет на панель реестра кнопку, нажатие на которую загружает кастомный контент вместо списка записей реестра.

![Демонстрация](registry-toolbar-button.webm)

**Поддерживаемая версия Synergy**: 3.15(wilkes)

**Файл конфигурации**: [emc/registry-toolbar-button.conf.xml](../../emc/registry-toolbar-button.conf.xml)

## Инструкция по использованию

Свойства компонента:

* кнопка имеет два состояния - выключена/включена;
* добавлять можно несколько кнопок (каждый вызов `new RegistryToolbarButtonExt()` добавляет одну кнопку);
* в состоянии "включена" может быть только одна кнопка;
* для иконки кнопки используется [Font Awesome](https://fontawesome.com);
* при переключении реестра состояние всех кнопок становится "выключена" и отображается список записей реестра;
* компонент не содержит условной логики отображения кнопки.

***Внимание!*** Компонент не реализует какой-либо логики описывающей в каких случаях, для кого и т.п. должна быть видна/доступна кнопка. Данную логику необходимо реализовать самостоятельно, в зависимости от задачи!

***Описание конструктора компонента:***

```javascript
/**
* Добавляет кнопку на тулбаре реестра, начиная за кнопкой отчетов реестра (иконка принтера).
* Каждый экземпляр объекта добавляет одну кнопку (new RegistryToolbarButtonExt(iframeSrc, faIcon)).
* В качестве иконки используется библиотека fontawesome 5 (https://fontawesome.com/icons?d=gallery&amp;m=free),
* т.о. необходимо выбрать иконку из библиотеки и передать ее код в конструктор.
* Конструктор метода позволяет отобразить iframe или произвольный HTML контент вместо списка записей реестра.
*
* @param {String} iframeSrc - URL который необходимо загрузить в iframe
* @param {String} faIcon - код иконки из fontawesome вместе с ее начертанием, например "fas fa-chart-pie"
* @param {jQuery} content - объект jQuery, который будет отображен вместо iframe. Если передан данный
*                           параметр, то параметр iframeSrc игнорируется.
*/
function RegistryToolbarButtonExt(iframeSrc, faIcon, content) {
}
```

***Пример добавления кнопки:***

```javascript
$EVENT_BUS.subscribe(new EventHandler('REGISTRY_SELECTED', function(event, args){

    var button1 = new RegistryToolbarButtonExt("http://demo.arta.kz","fas fa-chart-pie");
}));
```

В примере выше будет добавлена кнопка при выборе любого реестра. Нажатие на кнопку загрузит URL `http://demo.arta.kz` в iframe, который заменит список записей реестра.

***Пример добавления нескольких кнопок:***

```javascript
$EVENT_BUS.subscribe(new EventHandler('REGISTRY_SELECTED', function(event, args){

    var button1 = new RegistryToolbarButtonExt("http://demo.arta.kz","fas fa-chart-pie");

    var content = jQuery('<p id="my_content">Some content goes here</p>');
    var button2 = new RegistryToolbarButtonExt(null,"fas fa-crosshairs", content);

}));
```

В примере выше добавляются две кнопки при выборе любого реестра. Вторая кнопка отображает кастомный контент (в данном случае это просто элемент "параграф" с текстом).
