const auth = `Basic ${btoa(unescape(encodeURIComponent('yandexphp:1')))}`;

/**
 * Загружаем файлы пользователя из вне в платформу Synergy
 *
 * @param {string} nodeUUID - Идентификатор ноды файла по форме в хранилище
 * @param {string | int} dataUUID - Идентификатор данных по форме
 * @param {formData} data - файл(ы) в объекте formData
 * @return {string} fileId
 */
const uploadFile = async (nodeUUID, dataUUID, data) => {
    try {
        const url = window.location.origin + '/Synergy/rest/api/asffile?' + jQuery.param({
            type: 'attachment',
            node: nodeUUID || '',
            data: dataUUID || ''
        });

        return await jQuery.ajax({
            url,
            type: 'POST',
            beforeSend: xhr => xhr.setRequestHeader("Authorization", auth),
            data,
            cache: false,
            contentType: false,
            processData: false
        });
    }catch(e){
        console.error(e);
        return e.message;
    }
}

/**
 * Получаем информацию о файле по его fileId
 *
 * @param {string} fileId - Идентификатор файла
 * @return {object}
 */
const getDescriptionByFileId = async fileId => {
    try {
        const url = window.location.origin + `/Synergy/rest/api/storage/description?elementID=${fileId || ''}`;

        return await jQuery.ajax({
            url,
            beforeSend: xhr => xhr.setRequestHeader("Authorization", auth),
            dataType: 'json'
        });
    }catch(e){
        console.error(e);
        return e.message;
    }
}

/**
 * Получаем данные по форме 
 *
 * @param {string | int} dataUUID - Идентификатор данных по форме
 * @return {object}
 */
const getFormDataByDataId = async dataUUID => {
    try {
        const url = window.location.origin + `/Synergy/rest/api/asforms/data/${dataUUID}`;

        return await jQuery.ajax({
            url,
            beforeSend: xhr => xhr.setRequestHeader("Authorization", auth),
            dataType: 'json'
        });
    }catch(e){
        console.error(e);
        return e.message;
    }
}

/**
 * Сохранить файл в компоненте файл на форме
 *
 * @param {string | int} dataUUID - Идентификатор данных по форме
 * @param {string} componentId - Идентификатор компонента файл на форме
 * @param {object} fileDescription - Данные из API "rest/api/storage/description"
 * @return {object}
 */
const setFileToForm = async (dataUUID, componentId, fileDescription) => {
    try {
        const url = window.location.origin + `/Synergy/rest/api/asforms/data/merge`;
        const { name: value, identifier: key } = fileDescription;

        const { uuid } = await jQuery.ajax({
            url,
            type: 'POST',
            beforeSend: xhr => xhr.setRequestHeader("Authorization", auth),
            headers: {
                'Content-type': 'application/json'
            },
            dataType: 'json',
            data: JSON.stringify({
                uuid: dataUUID,
                data: [{
                    id: componentId,
                    type: 'file',
                    key,
                    value
                }]
            })
        });

        return !!uuid;
    }catch(e){
        console.error(e);
        return e.message;
    }
}






/**
 * Examle use keys - upload file`s to Synergy platform
 */
const nodeElement = document.createElement('input');
nodeElement.type = 'file';

nodeElement.onchange = async e => {
    const { files } = e.target;

    if(files && files.length){
        const data = new FormData();
        const file = files[0];

        data.append('file', file);

        // 17160 - dataUUID записи реестра
        const formData = await getFormDataByDataId(17160);

        if(formData && Object.keys(formData).length){
            const fileId = await uploadFile(formData.nodeUUID, formData.uuid, data);

            if(fileId){
                const { errorCode, errorMessage, name, identifier } = await getDescriptionByFileId(fileId);

                if(+errorCode !== 13){
                    const isSaved = await setFileToForm(formData.uuid, 'myFileCompId', ({ name, identifier }));

                    if(isSaved){
                        console.log(`Файл "${file.name}" - успешно загружен и установлен в компонент файл по форме`);
                    }else{
                        console.error(`Не удалось добавить файл "${file.name}" в компонент файл по форме.`);
                    }
                }else{
                    console.error(errorMessage);
                }
                return;
            }
        }

        console.error(`Произошла неизвестная ошибка, не удалось загрузить файл ${file.name}`);
    }

    nodeElement.remove();
}

nodeElement.click();