# devTools

Класс для работы с данными по форме через интерпретатор.

![Демонстрация](devToolsInterpreter.webm)

**Автор**: [Антонович Сергей](mailto:s.antonovich@arta.pro)

**Поддерживаемая версия Synergy**: 3.15 (wilkes)

## Возможности класса

* `load` - Подгружает данные по форме
* `getData` - Возвращает JSON данных по форме
* `getUUID` - Возвращает UUID текущией формы
* `getDocumentId` - Вернёт dataUUID по указаному documentId
* `getDataUUID` - Вернёт documentId по указаному dataUUID
* `getValue` - Возвращает значение
* `setValue` - Устанавливает новое значение
* `getRowCount` - Вернёт кол-во строк в динамической таблице
* `convertTable` - Конвертирует таблицу в читаемый вид
* `save` - Сохроняет данные по форме
* `destroy` - Очищает работу с текущей формой
* `api` - Выполняет API методы Synergy
* `log` - Для удобного просмотра JSON в самом интерпретаторе

## Аргументы функций

`load`(@param **dataUUID `String`**)

`getData`(void)

`getUUID`(void)

`getDocumentId`(@param **dataUUID `String`**)

`getDataUUID`(@param **documentId `String`**)

<hr>

`getValue`(@param **componentID `String`**, @param **key `String`**)

`getValue`(@param **componentID `String`**, @param **tableID `String`**, @param **lineNumber `Int`**, @param **key `String`**)

<hr>

`setValue`(@param **componentID `String`**, @param **value `String or Object`**, @param **key `String`**)

`setValue`(@param **componentID `String`**, @param **tableID `String`**, @param **lineNumber `Int`**, @param **value `String or Object`**, @param **key `String`**)

<hr>

`getRowCount`(@param **tableID `String`**)

`convertTable`(@param **dataTable `Array`**)

`save`(void)

`destroy`(void)

`api`(@param **method `String`**, @param **paramsObj `Object`**, @param **type `String`**, @param **dataText `Boolean`**)

## Инструкция по использованию

* Добавить скрипт в интерпретатор и можно использовать.

```javascript
function devTools(){let accessData=false;let formData=false;let formUUID=false;this.load=function(dataUUID){var content=this.api('asforms/data/'+dataUUID);accessData=(content.errorCode!='13');formUUID=dataUUID;formData=content.data;return this;};this.getData=function(){if(!accessData)return;return formData;};this.getUUID=function(){if(!accessData)return;return formUUID;};this.getDocumentId=function(dataUUID){return this.api('asforms/data/document?dataUUID='+dataUUID)};this.getDataUUID=function(documentId){return ""+this.api('formPlayer/getAsfDataUUID?documentID='+documentId,{},'GET',true);};this.getValue=function(){if(!accessData)return;var data;var args={c:arguments[0],ot:arguments[1],b:arguments[2],o:arguments[3]};if(typeof(args.c)==='string'&&typeof(args.b)==='number'){formData.forEach(function(item){if(item.id==args.ot){item.data.forEach(function(bItem){if(bItem.id.indexOf(args.c+'-b'+args.b)!==-1){data=(args.o)?bItem[args.o]:bItem;return;}});return;}});}else{formData.forEach(function(item){if(item.id==args.c){data=(args.ot)?item[args.ot]:item;return;}});}return data;};this.setValue=function(){if(!accessData)return;var args={c:arguments[0],vt:arguments[1],ob:arguments[2],v:arguments[3],o:arguments[4]};if(typeof(args.c)==='string'&&typeof(args.ob)==='number'){if(args.ob==0)args.ob=1;formData.forEach(function(item){if(item.id==args.vt){item.data.forEach(function(bItem){if(bItem.id.indexOf(args.c+'-b'+args.ob)!==-1){if(typeof(args.v)==='object')for(var aItem in args.v)bItem[aItem]=args.v[aItem];else bItem[(args.o)?args.o:'value']=args.v;return;}});return;}});}else{formData.forEach(function(item){if(item.id==args.c){if(typeof(args.vt)==='object')for(var aItem in args.vt)item[aItem]=args.vt[aItem];else item[(args.ob)?args.ob:'value']=args.vt;return;}});}};this.getRowCount=function(tableID){if(!accessData)return;var len=0;formData.forEach(function(item){if(item.id==tableID){item.data.forEach(function(tblItem){var regex=tblItem.id.match(/\-b(\d+)/);if(regex&&parseInt(regex[1])>len)len++;});return;}});return len;};this.convertTable=function(data){if(!accessData)return;var conArr=[];var b;data.forEach(function(item){if(item.id.indexOf('-b')!==-1&&(b=item.id.match(/(.+)\-b(\d+)/))){if((b[2] in conArr)===false)conArr[b[2]]={};conArr[b[2]][b[1]]=item;return;}});for(var i=0;i<conArr.length;i++)if(conArr[i]==null)conArr.splice(i--,1);return conArr;};this.save=function(){if(!accessData)return;var save=this.api('asforms/data/save',{uuid:formUUID,data:'"data":'+JSON.stringify(formData)},'POST');return (save=='200');};this.destroy=function(){accessData=formData=formUUID=false;};this.api=function(method,params,type,dataText){if(!method)return;if(!type)type='GET';var host="http://127.0.0.1:8080/Synergy/rest/api/";var client=new org.apache.commons.httpclient.HttpClient();var creds=new org.apache.commons.httpclient.UsernamePasswordCredentials(login,password);client.getParams().setAuthenticationPreemptive(true);client.getState().setCredentials(org.apache.commons.httpclient.auth.AuthScope.ANY,creds);switch(type){case 'GET':var _p=[];for(var p in params)_p.push(p+'='+params[p]);var api = new org.apache.commons.httpclient.methods.GetMethod(host+method+_p.join('&amp'));api.setRequestHeader("Content-type","application/json");client.executeMethod(api);var result=api.getResponseBodyAsString();break;case 'POST':var api=new org.apache.commons.httpclient.methods.PostMethod(host+method);for(var p in params)api.addParameter(p,params[p]);api.setRequestHeader("Content-type","application/x-www-form-urlencoded; charset=utf-8");var result=client.executeMethod(api);break;default:return;}api.releaseConnection();return (!dataText?JSON.parse(result):result);};this.log=function(data){var logViewer=function(data){if(typeof(data)!='string')data=JSON.stringify(data,null,4);data=data.replace(/&/g,'&amp;').replace(/</g,'&lt;').replace(/>/g,'&gt;');return data.replace(/("(\\u[a-zA-Z0-9]{4}|\\[^u]|[^\\"])*"(\s*:)?|\b(true|false|null)\b|-?\d+(?:\.\d*)?(?:[eE][+\-]?\d+)?)/g,function(match){var cls='number';if(/^"/.test(match)){cls=(/:$/.test(match)?'key':'string');}else if(/true|false/.test(match)){cls='boolean';}else if(/null/.test(match)){cls='null';}return '<span class="log-color-'+cls+'">'+match+'</span>';});};data='<pre style="color:#fff;background:#282828;border:0;font-size:14px;">'+logViewer(data)+'</pre>';var styleW='.log{width:850px;max-height:540px;border:1px solid #b3b3b3;border-radius:3px;padding:8px;background:#282828;color:#fff;overflow:auto;}';var styleC='.log-color-key{color:#ff7a00;}.log-color-string{color:#f9f9b3;}.log-color-null{color:#9771ff;}.log-color-number{color:#00b3ff;}.log-color-boolean{color:#3ef38a;}';var styleWP='.alert-success{color:rgba(0,0,0,1);background-color:#dedede;border-color:#b3b3b3;}';var window='<style>'+styleWP+styleW+styleC+'</style><div class="log">'+data+'</div>';return window;};return this;};
```

## Примеры к функциям

>Получить значение компонента или компонента в дин.таблице

```javascript
var form = new devTools().load(dataUUID);
form.getValue('Название компонента'); // Вернет объект
form.getValue('Название компонента','Ключ'); // Вернет значение ключа

form.getValue('Название компонента','Название таблицы','Номер строки','Ключ'); // Не указывая ключ, вернется объект
```

>Изменить значение компонента или компонента в дин.таблице

```javascript
var form = new devTools().load(dataUUID);
form.setValue('Название компонента','Значение'); // Изменит текст компонента
form.setValue('Название компонента','Значение','Ключ'); // Изменит текст у ключа
form.setValue('Название компонента',{
    key1: 'value1',
    key2: 'value2'
}); // Изменится объект у компонента

form.setValue('Название компонента','Название таблицы','Номер строки','Значение или объект','Ключ');
```

>Работа с api методами

```javascript
var uuid = 'xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx';
var form = new devTools().load(dataUUID);
var data = form.api('asforms/data/' + uuid); // [GET]

var data = form.api('asforms/data/save',{
    uuid: uuid,
    data: '"data":' + JSON.stringify(data)
},'POST'); // [POST]
```

>Конвертировать таблицу

```javascript
var form = new devTools().load(dataUUID);
var arr = form.convertTable(fd.getValue('Название таблицы','data'));
```