const createRegistryRow = async registryID => {
  Cons.showLoader();
  try {
    const regInfo = await appAPI.getRegistryInfoByID(registryID);

    if(!regInfo) throw new Error(i18n.tr('При создании записи произошла ошибка. Не удалось плучить информацию по реестру.'));
    if(regInfo.rr_create != "Y") throw new Error(i18n.tr('У вас нет прав на создание записи'));

    const doc = await appAPI.createDoc(regInfo.code);
    if(!doc) throw new Error(i18n.tr('Произошла ошибка при создании данного типа документа'));


    Cons.hideLoader();

    const eventParam = {
      type: 'document',
      documentID: doc.documentID,
      editable: true,
    };

    $('#root-panel').trigger({type: 'custom_open_document', eventParam});
  } catch (err) {
    showMessage(err.message, 'error');
    Cons.hideLoader();
  }
}

const checkEmpty = items => {
  let result = true;
  const s = arr => {
    arr.forEach(x => {
      if(x.is_bookmark == 1) result = false;
      if(x.is_group == 1) s(x.items);
    });
  }
  s(items);
  return result;
}

const getItemTitle = item => {
  const title = item.translations.find(x => x.locale == AS.OPTIONS.locale);
  return title ? title?.value : item.title;
}

const getFavoritesModal = body => {
  const dialog = $('<div class="uk-flex-top" uk-modal="bg-close: false; esc-close: false;">');
  const md = $('<div class="uk-modal-dialog uk-margin-auto-vertical">');
  md.append(`<button class="uk-modal-close-default modal-close-custom" type="button" uk-close></button>`,
`<div class="uk-modal-header"><h3>${i18n.tr("Избранное")}</h3></div>`, body);
  dialog.append(md);
  return dialog;
}

const getSearchComponent = () => {
  const container = $('<div>', {class: "uk-inline", style: "width: 100%"});
  const icon = $(`<a class="uk-form-icon uk-form-icon-flip" href="#" uk-icon="icon: search"></a>`);
  const input = $(`<input class="uk-input" type="text">`);

  container.append(icon, input)

  return {container, icon, input};
}

const favoritesInit = (items, successHandler) => {
  let selected = null;
  let itemsIsChange = false;

  const favoritesContainer = $('<div>', {class: "qam_favorites_modal_container"});
  const search = getSearchComponent();
  const itemsContainer = $('<div>', {class: "qam_favorites_items_container"});
  const buttonsContainer = $('<div>', {class: "qam_favorites_buttons"});

  const buttonApply = $('<button>', {
    class: "uk-button uk-button-primary",
    style: "border-radius: 3px;",
    disabled: true
  });

  const modal = getFavoritesModal(favoritesContainer);

  const renderFavoritesItem = listItems => {
    for(let i = 0; i < listItems.length; i++) {
      const item = listItems[i];
      const itemTitle = getItemTitle(item);

      if(item.is_group == 1) {
        const d = $('<div>', {class: "favorites_group"});
        d.text(itemTitle);
        d.attr('menu_itemID', item.menu_itemID);
        itemsContainer.append(d);
        renderFavoritesItem(item.items);
      } else {
        if(itemsContainer.find(`[menu_itemid="${item.menu_itemID}"]`).length) continue;

        const d = $('<div>', {class: "favorites_item_container"});
        const itemIcon = $('<div>', {class: "favorites_icon"});
        const itemTitle = $('<div>', {class: "favorites_title"});

        if(item.is_bookmark == 1) {
          itemIcon.attr('is_bookmark', true);
        } else {
          itemIcon.attr('is_bookmark', false);
        }

        d.attr('menu_itemID', item.menu_itemID);

        itemTitle.text(itemTitle);
        itemIcon.append(`<span uk-icon="icon: star"></span>`);
        d.append(itemIcon, itemTitle);
        itemsContainer.append(d);

        d.on('click', e => {
          buttonApply.attr('disabled', false);
          $('.favorites_item_container').removeClass('selected');
          d.addClass('selected');
          selected = item;
        });

        itemIcon.on('click', async e => {
          try {
            const is_bookmark = item.is_bookmark == 0 ? 1 : 0;

            const setResult = await appAPI.setCreateMenuItems([{
              itemID: item.menu_itemID, is_bookmark
            }]);

            if(!setResult || setResult?.errorCode !== 0) throw new Error('Произошла ошибка изменения списка избранного');

            itemsIsChange = true;
            item.is_bookmark = is_bookmark;

            if(is_bookmark == 1) {
              itemIcon.attr('is_bookmark', true);
            } else {
              itemIcon.attr('is_bookmark', false);
            }

          } catch (err) {
            showMessage(i18n.tr(err.message), 'error');
          }
          
        });
      }
    }
  }

  const searchItem = () => {
    $.each(itemsContainer.find(".favorites_item_container"), function() {
      if($(this).text().toLowerCase().indexOf(search.input.val().toLowerCase()) === -1) $(this).hide();
      else $(this).show();
    });
  }

  buttonApply.text(i18n.tr('Выбрать'));
  buttonsContainer.append(buttonApply);
  favoritesContainer.append(search.container, itemsContainer, buttonsContainer);

  renderFavoritesItem(items);

  search.input.on('keyup', e => {
    searchItem();
  });

  search.icon.on('click', e => {
    searchItem();
  });

  buttonApply.on('click', e => {
    UIkit.modal(modal).hide();
    if(selected) createRegistryRow(selected.registryID);
  });

  UIkit.modal(modal).show();
  modal.on('hidden', () => {
    if(itemsIsChange && successHandler && typeof successHandler === 'function') successHandler();
    modal.remove();
  });

  $('#root-panel').on('change_locale', e => {
    buttonApply.text(i18n.tr('Выбрать'));
  });
}

this.QuickAccessMenu = class {
  constructor(buttonContainerSelector, defaultHandler, defaultHandlerTitle, addMenuItems) {
    this.buttonContainerSelector = buttonContainerSelector;
    this.defaultHandler = defaultHandler;
    this.defaultHandlerTitle = defaultHandlerTitle;
    this.addMenuItems = addMenuItems;

    this.init();
  }

  addButtonHandler(buttonCreate, buttonMenu){
    buttonCreate.off().on('click', e => {
      e.preventDefault();
      if(this.defaultHandler && typeof this.defaultHandler === 'function') {
        this.defaultHandler();
      }
    });

    buttonMenu.off().on('click', e => {
      e.preventDefault();
      this.openMenuWindow();
      console.log('show menu');
    });
  }

  renderButton(){
    const buttonsGroup = $('<div>', {class: 'qam_buttons_group'});
    const buttonCreate = $('<button>', {class: 'qam_button_create'});
    const buttonMenu = $('<button>', {class: 'qam_button_menu'});

    buttonCreate.text(i18n.tr('Создать'));
    buttonMenu.text('▼');

    buttonsGroup.append(buttonCreate, buttonMenu);

    this.buttonContainer.empty().append(buttonsGroup);

    this.addButtonHandler(buttonCreate, buttonMenu);

    $('#root-panel').on('change_locale', e => {
      buttonCreate.text(i18n.tr('Создать'));
    });
  }

  getCloseButton(){
    const button = $('<div>', {class: 'qam_menu_close_button'});
    button.append(`<svg width="25" height="25" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg" data-svg="close-large"><line fill="none" stroke="#666" stroke-width="1.4" x1="1" y1="1" x2="19" y2="19"></line><line fill="none" stroke="#666" stroke-width="1.4" x1="19" y1="1" x2="1" y2="19"></line></svg>`);
    return button;
  }

  openMenuWindow(){
    this.menuContainer.addClass('active');
    this.renderMenuItems();
  }

  closeMenuWindow(){
    this.menuContainer.removeClass('active');
    this.contentContainer.empty();
    this.inputSearch.val(null);
  }

  getSearchInput(){
    const container = $('<div>');
    const inline = $('<div>', {class: 'uk-inline'});
    const input = $('<input>', {class: 'uk-input', id: 'qam_input_search', type: 'text', placeholder: `${i18n.tr('Поиск')}...`});
    const icon = $('<span>', {class: 'uk-form-icon uk-form-icon-flip', 'uk-icon': 'icon: search'});

    inline.append(icon, input);
    container.append(inline);

    $('#root-panel').on('change_locale', e => {
      input.attr('placeholder', `${i18n.tr('Поиск')}...`);
    });

    return {container, input};
  }

  renderSearchItems(items) {
    this.contentContainer.empty();

    const itemsContainer = $('<ul>', {class: 'qam_item_list_container uk-list uk-list-striped'});

    items.forEach(item => {
      const listItem = $('<li>', {class: 'qam_item_list_item'});
      const title = item.translations.find(x => x.locale == AS.OPTIONS.locale);

      listItem.text(getItemTitle(item));

      listItem.on('click', () => {
        this.closeMenuWindow();
        createRegistryRow(item.registryID);
      });

      itemsContainer.append(listItem);
    });

    this.contentContainer.append(itemsContainer);
  }

  renderMenuItems() {
    this.contentContainer.empty();

    const render = (items, level = 0) => {
      const menuList = $('<div>', {
        class: 'qam_menu_list',
        'data-level': level
      });

      items.forEach(item => {
        const titleValue = getItemTitle(item);

        if (item.is_group == 1 && !checkEmpty(item.items)) {
          const groupItem = $('<div>', {
            class: 'qam_menu_item qam_menu_item_group',
            text: titleValue
          });

          groupItem.on('click', e => {
            e.preventDefault();
            e.stopPropagation();

            const isActive = groupItem.hasClass('active');

            menuList.find('.qam_menu_item_group').removeClass('active');

            this.contentContainer
            .find('.qam_menu_list')
            .filter((_, el) => Number($(el).data('level')) > level)
            .remove();

            if (isActive) return;

            groupItem.addClass('active');
            render(item.items, level + 1);
          });


          menuList.append(groupItem);
        } else if (item.is_group == 0 && item.is_bookmark == 1) {
          const menuItem = $('<div>', {
            class: 'qam_menu_item',
            text: titleValue
          });

          menuItem.on('click', e => {
            e.preventDefault();
            e.stopPropagation();
            this.closeMenuWindow();
            createRegistryRow(item.registryID);
          });

          menuList.append(menuItem);
        }
      });

      this.contentContainer.append(menuList);
    };

    render(this.items, 0);
  }


  renderMenuWindow(){
    this.menuContainer = $('<div>', {class: 'qam_menu_container'});
    this.contentContainer =$('<div>', {class: 'qam_menu_container_content'});
    const header = $('<div>', {class: 'qam_menu_container_header'});

    const headerLeftPanel = $('<div>', {class: 'qam_menu_container_header_left'});
    const headerRightPanel = $('<div>', {class: 'qam_menu_container_header_right'});

    const closeButton = this.getCloseButton();

    const favoritesButton = $('<button>', {class: 'qam_favorites_button'});
    favoritesButton.text(i18n.tr('Ещё...'));

    const {container: containerSearch, input: inputSearch} = this.getSearchInput();
    this.inputSearch = inputSearch;
    inputSearch.on('input', e => {
      const searchValue = e.target.value;
      if(searchValue && searchValue != '') {
        this._search.searchDebounced(searchValue);
      } else {
        this.renderMenuItems();
      }
    });

    const searchFilterItems = [{title: 'Любое совпадение слов', value: 'OR'}, {title: 'Содержатся все слова', value: 'AND'}];
    const selectFilterSearch = new CustomSelect({items: searchFilterItems, defaultValue: this._search.filterCondition, classList: 'qam_filter_select_search'});
    const selectFilterLabel = $('<span>', {class: 'uk-text-bolder'});
    selectFilterLabel.text(i18n.tr('Условие поиска:'));

    selectFilterSearch.container.on('selected', e => {
      this._search.filterCondition = e.eventParam.value;
      const searchValue = inputSearch.val();
      if(searchValue && searchValue != '') {
        this._search.searchDebounced(searchValue);
      }
    });

    favoritesButton.on('click', e => {
      e.preventDefault();
      this.closeMenuWindow();
      favoritesInit(this.items, () => {
        this.updateItems();
      });
    });

    closeButton.on('click', e => {
      e.preventDefault();
      this.closeMenuWindow();
    });

    this.contentContainer.on('click', () => {
      this.contentContainer
      .find('.qam_menu_list')
      .filter((_, el) => Number($(el).data('level')) > 0)
      .remove();

      this.contentContainer.find('.qam_menu_item_group.active').removeClass('active');
    });

    headerLeftPanel.append(favoritesButton);
    headerRightPanel.append(containerSearch, selectFilterLabel, selectFilterSearch.container, `<hr class="uk-divider-vertical" style="height: 30px;">`, closeButton);
    header.append(headerLeftPanel, headerRightPanel);

    this.menuContainer.append(header, this.contentContainer);
    $('body').append(this.menuContainer);

    this.renderMenuItems();

    $('#root-panel').on('change_locale', e => {
      favoritesButton.text(i18n.tr('Еще...'));
      selectFilterLabel.text(i18n.tr('Условие поиска:'));
    });
  }

  async updateItems(){
    this.items = await appAPI.getCreateMenuItems();
    this._search = new MenuSearch(this.items);
  }

  async init(){
    try {
      if(!this.buttonContainerSelector)  throw new Error('Не передан селектор контейнера для отрисовки кнопки "Создать"');

      this.buttonContainer = $(this.buttonContainerSelector);

      await this.updateItems();

      this._search.searchDebounced = this._search.debounce((value) => {
        const result = this._search.search(value);
        this.renderSearchItems(result);
      }, 500);
      
      this.renderButton();
      this.renderMenuWindow();

    } catch (err) {
      console.log(err.message);
    }
  }
}