# :butterfly: Библиотека `jSynergy 1.0.9`

:point_right: Данный класс предназначен для работ с платформой Synergy.<br>

:point_right: Особенностями класса является метод `client` работает как вне блок-процесса так и внутри (авто-определение)

:clock8: Экономия вашего времени

:rocket: Пишите бизнес-логику быстрее и экономьте свое время

Пишите свой код внутри браузера прямо в консоли для более гибкой и удобной отладки.<br/>Если код работает то смело переносите его в интерпретатор.<br/>
Ну или же пишите на хардкоре прямо в БП :sweat_smile:

### ⚠ Внимание!
> PSS:
>   - Пишите код на странице с открытой *Synergy* или *SynergyAdmin* или *Configurator* для предотвращения CORS
>   - После синхронизации кода на сервере в БП не указывайте defaultSystemUser login & password на кириллице! (BASE64 - НЕ ПОДДЕРЖИВАЕТСЯ НА СТОРОНЕ СЕРВЕРА)

### :coffee: Disclaimer:

> Автор не несет ответственности за неправильное функционирование, нанесенный ущерб, неработоспособность и т.д. Который можно получить при использовании данного `класса`. А также не обязуется за доработку его возможностей по вашим прихотям.<br>

<hr/>

### Совместимость с версиями Synergy

* `Работоспособность` - это потверждение того что в определенных версиях Synergy есть нужные API, а так же что библиотека будет работать но возможны и последствия так что утвердитесь в пункте `Проверено`

| :beginner: **Версия Synergy** | :hammer_and_wrench: **Работоспособность** | **Проверено** |
| ------ | ------ | ------ |
| **3.*** | <div align="center">:x:</div> | <div align="center">:x:</div> |
| **4.*** | <div align="center">:heavy_check_mark:</div> | <div align="center">:heavy_check_mark:</div> |
| **5.*** | <div align="center">:heavy_check_mark:</div> | <div align="center">:x:</div> |

**[:rice_ball: Библиотека jSynergy](./jSynergy.js)**

### Использование

Вызов класса с пред. установленной переменной: `jSynergy`.<br>
Или можете создать новый класс через объект класса `const varName = new __classSynergy()`.

> Если у вас версия платформы Synergy `4.*` и выше то там есть так называемые `Библиотеки для интерпретатора` пихаем класс туда и просто пропускаем шаг с созданием экземпляра класса тобишь `__classSynergy` и пропускаем авторизацию контейнера т.е 
`jSynergy.setConnection(false, login, password);`. Тогда можно сразу работать с классом и формами.

> PSS: пишите в комментах нарушения документации т.е метода нету или лежит в другом месте или еще что либо...

```javascript

    // Вернет `true & false` подключения к контейнеру
    jSynergy.testConnect();

    // Вернет текущие данные подключения к контейнеру
    jSynergy.getConnection();

    // Вернет dataUUID текущей формы
    jSynergy.getDataUUID();

    // Вернет documentID текущей формы
    jSynergy.getDocumentID();

    // Вернет nodeUUID текущей формы
    jSynergy.getNodeUUID();

    // Вернет formUUID текущей формы
    jSynergy.getFormUUID();

    // Вернет версию текущей формы
    jSynergy.getFormVersion();

    // Вернет данные по форме
    jSynergy.getFormData();

    // Вернет массив подключений к контейнерам
    jSynergy.getListConnection();

    // Выбрать другой контейнер по индексу
    jSynergy.selectConnection(2);

    // Добавить ноль к числу 1 и получить 01
    jSynergy.strAddZero(1);

    // Изменить кодировку на UTF-8
    jSynergy.utf8_encode('Привет мир!');

    // Изменить кодировку на CP1251 (Windows-1251)
    jSynergy.utf8_decode('Hello world!');

    // Информация о данном классе
    jSynergy.about.version; // версия класса
    jSynergy.about.author(); // информация об авторе класса
    jSynergy.about.created; // дата создания класса иначе последнее изменение
    jSynergy.about.platform_versions; // поддерживаемые версии платформы Synergy

    // Склонение слов (43 Бетонных блока | 145 Бетонных блоков | 1 Бетонный блок)
    jSynergy.getWordDeclination(['Бетонный блок','Бетонных блока','Бетонных блоков'],43);
    jSynergy.getWordDeclination(['Бетонный блок','Бетонных блока','Бетонных блоков'],145);
    jSynergy.getWordDeclination(['Бетонный блок','Бетонных блока','Бетонных блоков'],1);

    // Полное очищение класса в его исходное состояние
    jSynergy.destroy();
    
    /**
     * Подключения к контейнеру
     */
     
    // По умолчанию нужно подлюкчаться к самому себе это будет выглядеть так (Нечего не меняем - вставляем и идем дальше)
    jSynergy.setConnection(false, login, password);

    // Вариант подключения к контейнеру (первый)
    jSynergy.setConnection('https://synergy.arta.pro/Synergy/', 'login', 'password');

    // Вариант подключения к контейнеру (второй)
    jSynergy.setConnection('https://synergy.arta.pro/Synergy/', '$session', 'key');

    // Вариант подключения к контейнеру (третий)
    jSynergy.setConnection('https://synergy.arta.pro/Synergy/', '$key', 'token');

    /**
     * После подключения к контейнеру можно начинать работу с формами
     */

    // Загружаем формы №1 и №2 (можно и одну - это все пример)
    jSynergy.client.load(1337);
    jSynergy.client.load(1338); // текущей формой для работ будет эта 1338

    // А можно сразу загрузить несколько форм, но дальше нужно указать рабочую область.
    jSynergy.client.multiLoad([1337, 1338]);

    // Можно вернуть последнюю загруженную форму через метод `load`
    jSynergy.client.regainForm();

    // Можно глянуть список загруженных форм
    jSynergy.client.getFormsList();

    // Можно изменить рабочую область формы
    jSynergy.client.selectForm(1337); // рабочая область стала форма 1337

    // Если нужно прочитать дин.таблицу в нормальном виде
    jSynergy.client.converTable('my-table-id');

    // Если нужно получить данные компонента, если такой есть вернется его объект | иначе `false`
    jSynergy.client.getValue('my-component-static');

    // Вернется значение из ключа `value` если такой есть | иначе `false`
    jSynergy.client.getValue('my-component-static', 'value');

    // Если нужно получить данные компонента из дин.таблицы - вернется его объект
    jSynergy.client.getValue('my-component-static', 'my-table-id', 1);

    // Вернется значение из ключа `key` если такой есть | иначе `false`
    jSynergy.client.getValue('my-component-static', 'my-table-id', 1, 'key');

    // Если нужно изменить значение компонента (числовое поле) по умолчанию ключ `value` но для числового поля ключ `key`
    jSynergy.client.setValue('my-component-static-numeric', 438439);

    // Если нужно изменить значение компонента по умолчанию ключ `value`
    jSynergy.client.setValue('my-component-static-text', 'Hello World!');

    // Если нужно изменить значение ключа
    jSynergy.client.setValue('my-component-static-text', 'Hello World!', 'value');

    // Если нужно изменить значение компонента в дин.таблице
    jSynergy.client.setValue('my-component-static-text', 'my-table-id', 1, 'Hello World!');

    // Если нужно изменить несколько ключей
    jSynergy.client.setValue('my-component-static-text', {
        key: 'xxxx-xxxxxxx-xxxxx-xxxx-xxxx',
        value: 'Hello World!'
    });

    // Можно даже так. Объект будет в ключе `value`
    jSynergy.client.setValue('my-component-static-text',{
        key: 'xxxx-xxxxxxx-xxxxx-xxxx-xxxx',
        value: 'Hello World!'
    },'value');
    
    // Если нужно заполнить компонент `Ссылка на реестр`
    jSynergy.client.setValue('myRegistryLinkId', 'xxxx-xxxxxxx-xxxxx-xxxx-xxxx');
    
    // Если нужно заполнить компонент `Ссылка на реестр` для дин. таблицы
    jSynergy.client.setValue('myRegistryLinkId', 'my-table-id', 1, 'xxxx-xxxxxxx-xxxxx-xxxx-xxxx');

    // Если нужно получить кол-во рядов в дин.таблице
    jSynergy.client.getRowsCount('my-table-id');

    // Если нужно добавить ряд в дин.таблицу
    jSynergy.client.addRowTable('my-table-id', 5);

    // [Визуально] Если нужно получить визуальные новые ряды для дин.таблицы
    jSynergy.client.addRowTable('my-table-id', 5, true);

    // Если нужно удалить ряд из дин.таблицы
    jSynergy.client.removeRowTable('my-table-id',5);

    // Если нужно удалить несколько рядов из дин.таблицы
    jSynergy.client.removeRowTable('my-table-id',[2,3,4]);

    // Если нужно очистить дин.таблицу
    jSynergy.client.clearTable('my-table-id');

    // Если вам понадобится полностью кастамизировать то... Вернется лист компонентов по форме без таблиц.
    jSynergy.client.getAsfData();

    // Для добавления нового объекта в `asfData` P.S: если такой есть в конфигурации формы, но нет в данных по форме. (метод сразу сохраняет внесенный объект)
    jSynergy.client.addAsdData({
        id: 'new-obj',
        type: 'textbox',
        value: 'Hello World!'
    });

    // Для добавления нескольких новых объектов в `asfData` P.S: если такие есть в конфигурации формы, но нет в данных по форме. (метод сразу сохраняет внесенные объекты)
    jSynergy.client.addAsdData([{
        id: 'new-obj1',
        type: 'textbox',
        value: 'Hello World! #1'
    },{
        id: 'new-obj2',
        type: 'textbox',
        value: 'Hello World! #2'
    }]);

    // Для сохранения изменений `asfData` для примера в качестве измененных данных указан `getAsfData`
    jSynergy.client.setAsfData(jSynergy.client.getAsfData());

    // Сохранить изменения формы
    jSynergy.client.save();

    /**
     * Для выполнения API запроса несколько примеров:
     * методы можно писать так: 'asforms/data' или так 'rest/api/asforms/data' разница в '/rest/api/'
     */

    // GET
    jSynergy.client.api('asforms/data' + 1337);

    // GET
    jSynergy.client.api('registry/data_ext',{
        data: {
            loadData: true,
            reigstryCode: 'registry-code'
        }
    });

    // POST
    jSynergy.client.api('asforms/data/save',{
        data: {
            uuid: 1337,
            data: '"data":' + JSON.stringify(jSynergy.getFormData())
        },
        type: 'POST'
    });

    // Выполнить запрос от другого пользователя
    jSynergy.client.api('registry/list',{
        login: 'login', // $session or $key
        password: 'password', // key or token
    });

    /**
     * Дополонение. Готовые API методы (У методов в client есть асинхронность callback)
     */

    // Получить documentID по dataUUID
    jSynergy.client.ApiUtils.getDocumentID(1337);

    // Получить dataUUID по documentID
    jSynergy.client.ApiUtils.getDataUUID('xxxx-xxxxxxx-xxxxx-xxxx-xxxx');

    // Получить ход выполнения по dataUUID
    jSynergy.client.ApiUtils.getProcessExecution(1337);

    // Возвращает список доступных реестров авторизованному пользователю
    jSynergy.client.ApiUtils.getRegistryList();
```

### Корневые методы класса

* `jSynergy.setConnection` - 3 аргумента `host`, `login`, `password`<br>
Данная функция добавляет подключение к контейнеру а также записывается в лист.<br><br>
* `jSynergy.getConnection` - Без аргументов `void`<br>
Данная функция возвращает `Object` (объект) подключения к контейнеру.<br><br>
* `jSynergy.getListConnection` - Без аргументов `void`<br>
Данная функция возвращает `Array` (массив) раних подключенний контейнерам.<br><br>
* `jSynergy.selectConnection` - 1 аргумент `index`<br>
Данная функция возвращает `Array` (массив) раних подключенний контейнерам.<br><br>
* `jSynergy.getFormData` - Без аргументов `void`<br>
Данная функция возвращает данные по форме `после загрузки формы`<br><br>
* `jSynergy.getDataUUID` - Без аргументов `void`<br>
Данная функция возвращает UUID `после загрузки формы`<br><br>
* `jSynergy.getDocumentID` - Без аргументов `void`<br>
Данная функция возвращает UUID `после загрузки формы`<br><br>
* `jSynergy.getFormUUID` - Без аргументов `void`<br>
Данная функция возвращает UUID `после загрузки формы`<br><br>
* `jSynergy.getNodeUUID` - Без аргументов `void`<br>
Данная функция возвращает UUID `после загрузки формы`<br><br>
* `jSynergy.getFormVersion` - Без аргументов `void`<br>
Данная функция возвращает ID версии формы `после загрузки формы`<br><br>
* `jSynergy.testConnect` - Без аргументов `void`<br>
Данная функция возвращает проверку соединения с контейнером.<br><br>
* `jSynergy.destroy` - Без аргументов `void`<br>
Данная функция полностью очищает работу с классом.<br><br>
* `jSynergy.about` - под категория класса, тут вся информация о классе.<br><br>
* `jSynergy.getWordDeclination` - 2 аргумента `Array`, `Integer`<br>
Данная функция возвращает склонения слова из массива по числу.<br><br>
* `jSynergy.strAddZero` - 2 аргумента `Integer & String`, `Integer`<br>
Данная функция возвращает тоже число или текст, но вначале добавляется ноль.<br><br>
* `jSynergy.utf8_encode` - 1 аргумент `String`<br>
Данная функция возвращает текст в кодировке `UTF-8`<br><br>
* `jSynergy.utf8_decode` - 1 аргумент `String`<br>
Данная функция возвращает текст в кодировке `CP1251`<br><br>
* `jSynergy.client` - под категория класса<br>
Данная категория работает везде где используется `javaScript`<br><br>
* `jSynergy.server` - под категория класса<br>
Данная категория работает `только` в платформе `Synergy` для написания `Блок процессов` в интерпретаторе.<br><br>

#### client класса
* `jSynergy.client.load` - 1 аргумент `Integer & String`<br>
Данная функция подгружает данные по форме.<br><br>
* `jSynergy.client.save` - Без аргументов `void`<br>
Данная функция сохраняет измененные данные по форме.<br><br>
* `jSynergy.client.multiLoad` - 1 аргумент `Integer & String & Array`<br>
Данная функция подгружает все перечисленные данные форм.<br><br>
* `jSynergy.client.getFormsList` - Без аргументов `void`<br>
Данная функция возвращает все данные по формам после их подгрузки.<br><br>
* `jSynergy.client.selectForm` - 1 аргумент `Integer & String`<br>
Данная функция устанавливает работу с выбранной формой по её идентификатору.<br><br>
* `jSynergy.client.regainForm` - Без аргументов `void`<br>
Данная функция возвращает форму загруженную через `jSynergy.client.load`. Последнюю загруженную форму.<br><br>
* `jSynergy.client.getAsfData` - Без аргументов `void`<br>
Данная функция возвращает все компоненты ввиде листа.<br><br>
* `jSynergy.client.addAsfData` - 1 аргумент `Object`<br>
Данная функция добавляет в лист компонентов новый `Object` (объект).<br><br>
* `jSynergy.client.setAsfData` - 1 аргумент `Array`<br>
Данная функция устанавливает новый лист компонентов.<br><br>
* `jSynergy.client.converTable` - 1 аргумент `String`<br>
Данная функция конвертирует таблицу в читаемый вид.<br><br>
* `jSynergy.client.getRowsCount` - 1 аргумент `String`<br>
Данная функция возвращает кол-во рядов в дин.таблице.<br><br>
* `jSynergy.client.addRowTable` - 3 аргумента `String`, `Integer`, `Boolean`<br>
Данная функция добавляет в дин.таблицу ряды. Третий аргумент при значении `true` нечего не добавляет.<br><br>
* `jSynergy.client.removeRowTable` - 2 аргумента `String`, `Integer`<br>
Данная функция удаляет ряд по его `index`.<br>Внимание под индексом подразумивается `-b1`, `-b2`, ... только без `-b`.<br><br>
* `jSynergy.client.clearTable` - 1 аргумент `String`<br>
Данная функция очищает всю таблицу.<br><br>
* `jSynergy.client.getValue` - 4 аргумента `String`, `String`, `Integer & String`, `String`<br>
Данная функция возвращает данные компонента.<br>Первый аргумент `ID компонента`, Второй аргумент `Ключ или ID таблицы`, Третий аргумент `Index`, Четвёртый аргумент: `Ключ`. Если вам нужен статический компонент то логично указать 2 или 1 аргумент. Иначе если вам нужен компонент из дин.таблицы, то нужно указать 3 или 4 аргумента.<br><br>
* `jSynergy.client.setValue` - 5 аргументов `String`, `Integer & String & Object`, `Integer & String`, `String`<br>
Данная функция возвращает данные компонента.<br>Первый аргумент `ID компонента`, Второй аргумент `Ключ или ID таблицы`, Третий аргумент `Index`, Четвёртый аргумент: `Ключ`. Если вам нужен статический компонент то логично указать 2 или 1 аргумент. Иначе если вам нужен компонент из дин.таблицы, то нужно указать 3 или 4 аргумента.<br>
* `jSynergy.client.ApiUtils` - под категория, категории `jSynergy.client`<br>
Там лежат различные готовые API запросы.<br><br>
* `jSynergy.client.api` - метод для выполнения API запросов Synergy.
