const updateTranslations = () => {
  const {translations} = Cons.getAppStore();
  i18n.locale = AS.OPTIONS.locale;
  return new Promise(resolve => {
    rest.synergyGet(`system/messages?localeID=${AS.OPTIONS.locale}`,
      res => {
        i18n.messages = res;
        if(translations && translations != 'not found') {
          for(const key in translations) i18n.messages[key] = translations[key][AS.OPTIONS.locale];
        }
        resolve(true);
      },
      err => {
        i18n.messages = null;
        resolve(true);
      }
    );
  });
}

//доп функции для переводов
const localized = () => {
  updateTranslations();
}

if(!Cons.getAppStore().change_locale_listener) {
  addListener('change_locale', 'root-panel', e => {
    const {locale} = e;
    AS.OPTIONS.locale = locale;
    localStorage.locale = locale;
    localized();
  });

  updateTranslations();

  Cons.setAppStore({change_locale_listener: true});
}

if(localStorage.locale && localStorage.locale != AS.OPTIONS.locale) {
  fire({type: 'change_locale', locale: localStorage.locale});
}
