# Библиотека внешних компонентов ARTA Synergy

В данном проекте представлены различные внешние компоненты, которые были
реализованы в рамках проектов (или в свободное время) для платформы **ARTA Synergy**.

## Disclaimer

Все компоненты предоставлены сообществом по принципу ***"AS IS"*** и не подразумевают
какой-либо ответственности автора за неправильное функционирование,
нанесенный ущерб, неработоспособность и т.д.

**Также автор компонента не обязуется дорабатывать свой компонент под какой-либо проект**,
но вы всегда можете связаться с ним и предложить взаимовыгодные условия сотрудничества.
Либо заказать доработку или разработку нового компонента в Блоке Интеграционных Решений ДРТ.

## Структура проекта

Библиотека внешних компонентов разбита на несколько каталогов:

* `doc` - каталог документации к компонентам;
* `emc` - каталог ВМК (Внешний модуль-компонент);
* `form-cmp` - каталог пользовательских компонентов форм;
* `interpreter` - каталог скриптов Интерпретатора.

В каталогах, как правило, содержится экспортированная конфигурация с ARTA Synergy.

### Список компонентов

**Внешние модули-компоненты**

* [Дополнительная кнопка реестра](doc/emc/registry-toolbar-button.md)

**Пользовательские компоненты форм**

* [Иерархический справочник на основе реестров](doc/emc/tree-registry-chooser.md)
* [Числа прописью](doc/emc/number-to-string.md)
* [Нумерация строк в дин.таблицах](doc/emc/numbering-rows.md)
* [Прогресс-бар](doc/emc/progress-bar-ultimate.md)
* [Кнопка](doc/emc/custom-button.md)
* [Мультивыбор записей реестра](doc/emc/multi-registry-chooser.md)
* [CKEditor — свободный WYSIWYG-редактор](doc/emc/ck-editor.md)
* [Компонент выбора мероприятий проекта](doc/emc/action_chooser_component.md)

**Скрипты Интерпретатора**

* [jSynergy библиотека](interpreter/jSynergyDocs.md)
* [Скрипт создания документа в маршруте реестра](interpreter/createNewDocByScript)
* [Скрипт добавления печатного представления документа в Прочие](interpreter/printFileScript)
* [Сохранение произвольного значения компонента на форме через скрипт интерпретатора](interpreter/saveCustomValue) 

**Скрипты/сниппеты**

* [Подписание документа ЭЦП](doc/emc/signDocument.md)

### Дополнительно

* [Проект шаблона блокирующего процесса (Java)](http://gitlab.lan.arta.kz/community/blocking-process-template)
* [Проект шаблона веб-приложения с кастомным REST API (Java)](http://gitlab.lan.arta.kz/community/synergy-api-proxy)
