# Скрипт подписывает документ по ЭЦП

**Уровень сложности**: Разработчик

**Описание**: Скрипт подписывает документ по ЭЦП.

**Автор**: [Александра Башеева](mailto:a.basheyeva@arta.pro)

**Документация**: [Перейти](http://tdd.lan.arta.kz/docs/synergy/tags/wilkes/user-manual/html/appendix.html#a1)

>**Внимание**: работает только с `Synergy Agent`!

```javascript
function signDocument(documentId, successHandler, errorHandler){
    var user;
    var cert = null;
    var endInfo = null;
    var alg = null;
    var certId = null;
    var rawdata = null;
    var signedData = null;

    jQuery.when(AS.FORMS.ApiUtils.simpleAsyncGet("rest/api/person/auth")).then(function(person){
        user = person;
        return jQuery.get("https://local.arta.pro:8389/?TYPE=INFO");
    }).then(function(data){
        cert = data.CERT;
        endInfo = data.KEY_CN;

        return AS.FORMS.ApiUtils.simpleAsyncPost("rest/sign/verificationkey", null, "text", {uuid : user.userid, pemCer : cert, edsInfo : endInfo});
    }).then(function(result){
        if(result == null || result.indexOf("::::") == -1) {
            if(result == "CERT REVOKED") {
                alert("Сертификат отозван");
            } else {
                alert("Произошла ошибка проверки ключа");
            }
            throw new Error();
        }
        var args = result.split("::::");

        alg = args[1];
        certId = args[0];

        return AS.FORMS.ApiUtils.simpleAsyncGet("rest/api/docflow/doc/document_info?documentID="+documentId)

    }).then(function(documentInfo){
        rawdata = documentInfo.rawdata;
        return jQuery.post("https://local.arta.pro:8389/", {TYPE : 'SIGN', 'DATA' : rawdata, 'ALG' : alg});
    }).then(function(data){
        signedData = data.signedData;

        var sendData = {
            documentID: documentId,
            rawdata : rawdata,
            signdata : signedData,
            certificate : cert,
            certID : certId
        };
        return AS.FORMS.ApiUtils.simpleAsyncPost("rest/api/docflow/sign", null, "text", sendData);
    }).then(function(){
        if(successHandler) {
            successHandler();
        }
    }).fail (function(error){
        console.log(error);
        if(errorHandler) {
            errorHandler(error);
        }
    });
}
```