# Мобильная адаптивность формы Synergy через проигрыватель форм

![Описание](Library/Снимок_экрана_от_2018-10-23_12-45-07.png)

**Автор: [Антонович Сергей (yandexphp)](mail:antonovich_1313@mail.ru)**

<hr>

*Пример структуры HTML*

```html
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Page Title</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
    <link rel="stylesheet" href="mobile-window.css">
    <script src="mobile-window.js"></script>
    <script>FORM_PLAYER_URL_PREFIX = "http://127.0.0.1/Synergy/";</script> <!-- Для работы компонента HTD редактора -->
    <link rel="stylesheet" href="http://127.0.0.1/Synergy/js/form.player.css"/> <!--стандартный стиль компонентов формы-->
    <script src="http://127.0.0.1/Synergy/js/vendor.js" type="text/javascript"></script> <!--ссылка на сторонние библиотеки-->
    <script src="http://127.0.0.1/Synergy/js/form.player.js" type="text/javascript"></script> <!--ссылка на проигрыватель форм-->
</head>
<body>
    <div class="mobile-window">
        <div id="form_player_container">
            <div id="form_player_div"></div>
        </div>
    </div>
</body>
</html>
```

<hr>

*Структура CSS*

```css
body{
    margin: 0;
}
.mobile-window{
    padding: 5px;
}
.mobile-window .asf-textBox {
    border-radius: 0;
    border: 0;
}

.mobile-window .asf-invalidInput{
    border: 0 !important;
    background-color: transparent !important;
}

.mobile-window .asf-label{
    position: absolute;
    display: flex;
    align-items: center;
    left: 5px;
    color: #a0a0a0;
    font-size: 12px;
}

#mw-label-listbox{
    position: relative;
    cursor: default;
}

.mw-invalid-label-color-error, .mw-invalid-color-error{
    color:rgb(255, 19, 0);
}

.mw-invalid-label-color-success, .mw-invalid-color-success{
    color:rgb(63, 162, 63);
}

.mobile-window-system-select, .mobile-window-system-date, .mobile-window-system-box{
    position: absolute;
    z-index: 1;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    min-width: 100%;
    min-height: 100%;
    opacity: 0;
}

.mobile-window .asf-dateBox{
    min-width: calc(100% - 32px);
    min-height: 100%;
}

.mobile-window .asf-container{
    position: relative;
}

.mobile-window .asf-buttonLabel{
    padding: 4px 0;
}

.mobile-window .mobile-window-systemAlign{
    position: absolute;
    top: auto;
    bottom: auto;
    min-height: 14px;
    opacity: 0;
}
```

<hr>

*Пример использования*

Все достаточно просто. Нужно внести функцию выше после такой строки в проигрывателе форм.
```javascript
portal.player = AS.FORMS.createPlayer();
```

Шаблон без библиотеки
```javascript
'use strict';

var PLAYER_PARENT_HANDLER = '#form_player_div';

var portal = {
    player : null,
    clearPlayer : function() {
        if(portal.player) {
            portal.player.destroy();
        }
    },
    createPlayer: function(){
        portal.clearPlayer();
        portal.player = AS.FORMS.createPlayer();
        /**
         * сюда вставить нашу либу
         */
        portal.player.view.setEditable(true);
        portal.player.showFormByCode('mobile-modal-window-form');
        portal.player.view.appendTo($(PLAYER_PARENT_HANDLER));
    }
};

$(function(){
    AS.OPTIONS.locale = "ru";
    AS.OPTIONS.coreUrl = FORM_PLAYER_URL_PREFIX;
    AS.OPTIONS.login = "login|$session|$key";
    AS.OPTIONS.password = "password|key|token";
    portal.createPlayer();
});
```

```javascript
'use strict';

var PLAYER_PARENT_HANDLER = '#form_player_div';

var portal = {
    player : null,
    clearPlayer : function() {
        if(portal.player) {
            portal.player.destroy();
        }
    },
    createPlayer: function(){
        portal.clearPlayer();
        portal.player = AS.FORMS.createPlayer();
        AS.FORMS.bus.on('formShow',function(event,fModel,fView){
            fModel.on('dataLoad',function(event,dModel){
                if(/Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent)){

                    var __checkInvalidErrors = function(){
                        $('.asf-invalidInput').each(function(k,i){
                            var block = $(i).parent();
                            if($(i).hasClass('asf-invalidInput')){
                                //block.find('.asf-label').css('color','rgb(255, 19, 0)');
                                block.find('.asf-label').addClass('mw-invalid-label-color-error');
                                block.addClass('mw-invalid-color-error');
                                //block.css('border-bottom-color','rgb(255, 19, 0)');
                                if($(i).hasClass('asf-container')) 
                                    //$(i).css('border-bottom-color','rgb(255, 19, 0)');
                                    $(i).addClass('mw-invalid-color-error');
                                $(i).removeClass('asf-invalidInput');
                            }else{
                                block.find('.asf-label').addClass('mw-invalid-label-color-success');
                                //block.find('.asf-label').css('color','rgb(63, 162, 63)');
                                //block.css('border-bottom-color','rgb(187, 187, 187)');
                                block.addClass('mw-invalid-color-success');
                            }
                        });
                    };

                    var __select = function(combobox){
                        var items = combobox.listElements.slice();
                        if(!Array.isArray(items)) items = [items];

                        items.forEach(function(item,key){
                            items[key] = '<option value="' + item.value + '"' + (combobox.getValue() == item.value ? ' selected' : '') + '>' + item.label + '</option>'
                        });

                        var box = $('<select class="mobile-window-system-select">' + items.join('') + '</select>');
                        box.on('change',function(){
                            combobox.setValue(""+box.val());
                        });

                        var container = $(fView.getViewWithId(combobox.asfProperty.id).container);
                        container.append(box);
                        container.find('.asf-dropdown-button').off();
                        container.find('.asf-dropdown-input').off();
                    };

                    var __date = function(date){
                        var container = $(fView.getViewWithId(date.asfProperty.id).container);
                        var box = $('<input type="date" class="mobile-window-system-date">');
                        var curDate = new Date(""+date.getValue());

                        var month = {0: '01',1: '02',2: '03',3: '04',4: '05',5: '06',6: '07',7: '08',8: '09',9: '10',10: '11',11: '12'}[curDate.getMonth()];

                        box.on('change',function(){
                            AS.FORMS.ApiUtils.formatDate($(this).val() + ' 00:00:00',date.asfProperty.config.dateFormat).then(function(resFormatDate){
                                date.setValue("" + resFormatDate);
                                if(resFormatDate){
                                    container.find('.asf-label').animate({
                                        'top': '0',
                                        'font-size':'10px',
                                        'color': 'rgb(63, 162, 63)'
                                    },200);
                                    container.animate({'border-bottom-color':'rgb(63, 162, 63)'},200);
                                    container.find('.asf-dateBox').animate({'opacity':'1'},200);
                                }else{
                                    container.find('.asf-label').animate({
                                        'top': container.find('.mobile-window-systemAlign').position().top,
                                        'font-size':'12px',
                                        'color': 'rgb(187, 187, 187)'
                                    },200);
                                    container.animate({'border-bottom-color':'rgb(187, 187, 187)'},200);
                                    container.find('.asf-dateBox').animate({'opacity':'0'},200);
                                }
                            });
                        });

                        box.val(curDate.getFullYear()+'.'+month+curDate.getDate());
                        container.append(box);
                        container.find('.asf-calendar-button').off();
                        container.find('.asf-dateBox').off();
                    };

                    $('.mobile-window-system-date').remove();
                    $('.mobile-window-system-select').remove();
                    $('.asf-emptyCell').parent().hide();

                    fModel.value.data.forEach(function(item){
                        var container = $(fView.getViewWithId(item.id).container);
                        var parent = container.parent();

                        $('<div class="mobile-window-systemAlign"></div>').appendTo(container);

                        container.parent().attr('colspan','1');

                        var placeholder = (fView.getViewWithId(item.id + '-label') ? ""+dModel.getModelWithId(item.id + '-label').getValue() : false);

                        /**
                         * Является ли компонент скрытым - для скрытия его в мобильной версии
                         */
                        var visible = !container.is(':visible');

                        /**
                         * Переопределение отображения компонентов по их типу
                         */
                        switch(item.type.toLowerCase()){
                            /**
                             * LABEL
                             */
                            case 'label':
                                container.css({
                                    'border': '0',
                                    'border-radius': '0',
                                    'border-bottom': '1px solid rgb(187, 187, 187)',
                                    'display':'flex',
                                    'align-items':'center'
                                });
                                if(!/title$/.test(item.id)){
                                    parent.hide();
                                }else{
                                    container.find('.asf-label').css({
                                        'position':'relative',
                                        'color':'#000',
                                        'padding-bottom':'5px'
                                    });
                                }
                            break;
                            /**
                             * TEXTBOX & NUMERICINPUT
                             */
                            case 'textbox':
                            case 'numericinput':
                                var box = $('<div class="mobile-window-system-box"></div>');
                                box.css('opacity','1');
                                box.on('click',function(){
                                    container.find('input').focus();
                                    $(this).hide();
                                    container.find('input').animate({'opacity':'1'},200);
                                });
                                container.append(box);

                                container.css({
                                    'border': '0',
                                    'border-radius': '0',
                                    'border-bottom': '1px solid rgb(187, 187, 187)',
                                    'display':'flex',
                                    'align-items':'center'
                                });

                                container.css('min-height','35px');

                                container.find('.asf-label').text(placeholder ? placeholder : '');

                                container.find('.asf-label').click(function(){
                                    container.find('input').focus();
                                });

                                container.find('input').css({
                                    'padding-left': '6px',
                                    'padding-top': '5px',
                                    'opacity':'0'
                                });

                                container.find('input').attr('placeholder','');

                                container.find('input').focus(function(){
                                    if($(this).val() && dModel.getModelWithId(item.id).inputUtils.defaultValue != $(this).val()) return;
                                    $(this).parent().find('.asf-label').animate({
                                        'top': '0',
                                        'font-size':'10px',
                                        'color': 'rgb(63, 162, 63)'
                                    }, 200);
                                    container.animate({
                                        'border-bottom-color': 'rgb(63, 162, 63)'
                                    },200);
                                    container.find('.mobile-window-system-box').hide();
                                    container.find('input').animate({'opacity':'1'},200);
                                });

                                container.find('input').blur(function(){
                                    if(!$(this).val() || dModel.getModelWithId(item.id).inputUtils.defaultValue == $(this).val()){
                                        $(this).parent().find('.asf-label').animate({
                                            'top': container.find('.mobile-window-systemAlign').position().top,
                                            'font-size':'12px',
                                            'color': '#a0a0a0'
                                        }, 200);
                                        container.animate({
                                            'border-bottom-color': '#a0a0a0'
                                        },200);
                                        container.find('.mobile-window-system-box').show();
                                        container.find('input').animate({'opacity':'0'},200);
                                    }
                                });

                                container.find('input').on('input',function(){
                                    if($(this).hasClass('asf-invalidInput')){
                                        $(this).parent().find('.asf-label').css('color','rgb(255, 19, 0)');
                                        $(this).parent().css('border-bottom-color','rgb(255, 19, 0)');
                                    }else{
                                        if($(this).val()){
                                            $(this).parent().find('.asf-label').css('color','rgb(63, 162, 63)');
                                            $(this).parent().css('border-bottom-color','rgb(63, 162, 63)');
                                        }else{
                                            $(this).parent().find('.asf-label').css('color','rgb(187, 187, 187)');
                                            $(this).parent().css('border-bottom-color','rgb(187, 187, 187)');
                                        }
                                    }
                                });
                            break;
                            /**
                             * TEXTAREA
                             */
                            case 'textarea':
                                container.css({
                                    'border': '0',
                                    'border-radius': '0',
                                    'border-bottom': '1px solid rgb(187, 187, 187)',
                                    'display':'flex',
                                    'align-items':'center'
                                });

                                container.css({
                                    'min-height':'65px'
                                });

                                container.find('.asf-label').text(placeholder ? placeholder : '');

                                container.find('.asf-label').click(function(){
                                    container.find('textarea').focus();
                                });

                                container.find('textarea').css({
                                    'padding-left': '6px',
                                    'padding-top': '10px',
                                    'resize':'none'
                                });

                                container.find('textarea').attr('placeholder','');

                                container.find('textarea').focus(function(){
                                    if($(this).val()) return;
                                    $(this).parent().find('.asf-label').animate({
                                        'top': '0',
                                        'font-size':'10px',
                                        'color': 'rgb(63, 162, 63)'
                                    }, 200);
                                    container.animate({
                                        'border-bottom-color': 'rgb(63, 162, 63)'
                                    },200);
                                });

                                container.find('textarea').blur(function(){
                                    if(!$(this).val()){
                                        $(this).parent().find('.asf-label').animate({
                                            'top': container.find('.mobile-window-systemAlign').position().top,
                                            'font-size':'12px',
                                            'color': '#a0a0a0'
                                        }, 200);
                                        container.animate({
                                            'border-bottom-color': '#a0a0a0'
                                        },200);
                                    }
                                });

                                container.find('textarea').on('textarea',function(){
                                    if($(this).hasClass('asf-invalidInput')){
                                        $(this).parent().css('border-bottom-color','rgb(255, 19, 0)');
                                    }else{
                                        $(this).parent().css('border-bottom-color','rgb(187, 187, 187)');
                                    }
                                });
                            break;
                            /**
                             * LISTBOX
                             */
                            case 'listbox':
                                __select(dModel.getModelWithId(item.id));

                                container.find('.asf-label').text(placeholder ? placeholder : '');

                                container.find('.asf-label').click(function(){
                                    container.find('textarea').focus();
                                });

                                container.css({
                                    'border': '0',
                                    'border-radius': '0',
                                    'border-bottom': '1px solid rgb(187, 187, 187)',
                                    'padding': '5px 0 5px 5px',
                                    'width':'calc(100% - 5px)'
                                });

                                container.css({
                                    'display':'block'
                                });

                                container.find('.asf-dropdown-input').css({
                                    'border':'0',
                                    'padding-top': '4px'
                                });

                                container.find('.asf-dropdown-button').css({
                                    'background':'url(data:image/png;base64,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) no-repeat center',
                                    'border':'0'
                                });

                                container.find('input').on('input',function(){
                                    if($(this).hasClass('asf-invalidInput')){
                                        $(this).parent().find('.asf-label').css('color','rgb(255, 19, 0)');
                                        $(this).parent().css('border-bottom-color','rgb(255, 19, 0)');
                                    }else{
                                        $(this).parent().find('.asf-label').css('color','rgb(63, 162, 63)');
                                        $(this).parent().css('border-bottom-color','rgb(187, 187, 187)');
                                    }
                                });

                                if($(container).find('.asf-dropdown-input').text()){
                                    container.find('.asf-label').css('color','rgb(63, 162, 63)');
                                    container.css('border-bottom-color','rgb(63, 162, 63)');
                                }else{
                                    container.find('.asf-label').css('color','#a0a0a0');
                                    container.css('border-bottom-color','#a0a0a0');
                                }

                                dModel.getModelWithId(item.id).on('valueChange',function(){
                                    var curModel = dModel.getModelWithId(item.id);
                                    if(!curModel.getTextValue()){
                                        container.find('.asf-label').animate({
                                            'top': (parseInt(container.find('.mobile-window-systemAlign').position().top) - 20) + 'px',
                                            'font-size':'12px',
                                            'color': '#a0a0a0'
                                        }, 200);
                                        container.animate({
                                            'border-bottom-color': '#a0a0a0'
                                        },200);
                                    }else{
                                        container.find('.asf-label').animate({
                                            'top': '0',
                                            'font-size':'10px',
                                            'color': 'rgb(63, 162, 63)'
                                        }, 200);
                                        container.animate({
                                            'border-bottom-color': 'rgb(63, 162, 63)'
                                        },200);
                                    }
                                });
                                if(!dModel.getModelWithId(item.id).getTextValue()){
                                    container.find('.asf-label').animate({
                                        'top': (parseInt(container.find('.mobile-window-systemAlign').position().top) - 20) + 'px',
                                        'font-size':'12px',
                                        'color': '#a0a0a0'
                                    }, 200);
                                    container.animate({
                                        'border-bottom-color': '#a0a0a0'
                                    },200);
                                }else{
                                    container.find('.asf-label').animate({
                                        'top': '0',
                                        'font-size':'10px',
                                        'color': 'rgb(63, 162, 63)'
                                    }, 200);
                                    container.animate({
                                        'border-bottom-color': 'rgb(63, 162, 63)'
                                    },200);
                                }
                            break;
                            /**
                             * CHECKBOX & RADIOBOX
                             */
                            case 'check':
                            case 'radio':
                                dModel.getModelWithId(item.id).on('dataLoad',function(){
                                    var customLabel = $('<div class="asf-label" id="mw-label-listbox">' + (placeholder ? placeholder : '') + '</div>');

                                    customLabel.css({
                                        'top': '0',
                                        'font-size':'10px'
                                    });

                                    $(container).prepend(customLabel);

                                    dModel.getModelWithId(item.id).on('valueChange',function(){
                                        if(dModel.getModelWithId(item.id).getValue()){
                                            container.find('.asf-label').css({
                                                'color':'rgb(63, 162, 63)'
                                            });
                                            container.css({
                                                'border-bottom': '1px solid rgb(63, 162, 63)',
                                            });
                                        }else{
                                            container.find('.asf-label').css({
                                                'color':'rgb(187, 187, 187)'
                                            });
                                            container.css({
                                                'border-bottom': '1px solid rgb(187, 187, 187)',
                                            });
                                        }
                                    });
    
                                    if(dModel.getModelWithId(item.id).getValue()){
                                        container.find('.asf-label').css({
                                            'color':'rgb(63, 162, 63)'
                                        });
                                        container.css({
                                            'border-bottom': '1px solid rgb(63, 162, 63)',
                                        });
                                    }else{
                                        container.find('.asf-label').css({
                                            'color':'rgb(187, 187, 187)'
                                        });
                                        container.css({
                                            'border-bottom': '1px solid rgb(187, 187, 187)',
                                        });
                                    }
                                });
                            break;
                            /**
                             * DATE
                             */
                            case 'date':
                                __date(dModel.getModelWithId(item.id));

                                container.find('.asf-label').text(placeholder ? placeholder : '');

                                container.css({
                                    'width':'100%',
                                    'border-bottom': '1px solid rgb(187, 187, 187)',
                                    'display':'flex',
                                    'align-items':'center'
                                });

                                container.find('.asf-calendar-button').css({
                                    'background':'url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAABdElEQVR42q2SvyuFURjHr4GyyialDBbE7XblHzCyeBfD+7Pe/OjeLGInSSyyyCIDGQzqKkooRQbJYmJQSqF0Jwxcn6eeo4OX3sGtT88533PO9z7fc95M5r9/nuet+b6//l0PgmAO/SDxUBiGLSw6bMqKgZp0iKZ6lxjAPvM20VzXbf80QDiHCmyzqQ+DXuqWasIJWg91AFZVu7ENrq3Ni7BgzQ0rGsPM722DW9iDAowrBQ4MCZY+QSdF6iaUbYNHFibTXrSaPts3/wDTjuPUsHAGp9CEdkS9oDZTdzh4GcdxPePhHwYsTmFQy8IbvOhtlyUvN96pMWXckNgBwqy2l5UDDKvkqXjinIyjKGplntfIo4kRaK9aL3MXo0ZqCQ4lDvMNOMaojr0jf0WQJ3qXf9coFelKnk3HYjyYFGFGv8qcaVvj5E0c6Nb9xS8G8owwL69gNInz25i9Y9KdbXClt3+Xkld4sj+MfliSzzUNRFiGWM5+AHf0L2rZe6f2AAAAAElFTkSuQmCC) no-repeat center',
                                    'border':'0'
                                });

                                container.find('.asf-dateBox').css({
                                    'width':'100%',
                                    'max-width':'unset',
                                    'border':'0',
                                    'border-radius':'0',
                                    'opacity':'0'
                                });

                                if(dModel.getModelWithId(item.id).getValue()){
                                    container.find('.asf-label').css({
                                        'top': '0',
                                        'font-size':'10px',
                                        'color': 'rgb(63, 162, 63)'
                                    });
                                    container.css('border-bottom-color','rgb(63, 162, 63)');
                                    container.find('.asf-dateBox').css('opacity','1');
                                }else{
                                    container.find('.asf-label').css({
                                        'top': container.find('.mobile-window-systemAlign').position().top,
                                        'font-size':'12px',
                                        'color': 'rgb(187, 187, 187)'
                                    });
                                    container.css('border-bottom-color','rgb(187, 187, 187)');
                                }
                            break;
                        }
                        if(visible) container.hide();
                    });
                }

                $(fView.container).append('<div style="display: flex;justify-content: center;align-items: center;"><div class="send" style="    padding: 15px 20px;background: #557fd2;color: #fff;font-weight: bold;font-size: 14px;min-width: 150px;min-height: 15px; text-align: center; cursor: pointer;">Send Form</div></div>')
                
                $(fView.container).find('.send').on('click',function(){
                    if(portal.player.model.getErrors().length > 0){
                        __checkInvalidErrors();
                    }else{
                        // You`r code
                    }
                });

            });
        });
        
        portal.player.view.setEditable(true);
        portal.player.showFormByCode('mobile-modal-window-form');
        portal.player.view.appendTo($(PLAYER_PARENT_HANDLER));
    }
};

$(function(){
    AS.OPTIONS.locale = "ru";
    AS.OPTIONS.coreUrl = FORM_PLAYER_URL_PREFIX;
    AS.OPTIONS.login = "login|$session|$key";
    AS.OPTIONS.password = "password|key|token";
    portal.createPlayer();
});
```