# Описание работы с классом `class-synergy.php`

* Подключить сам class или скопировать его содержимое к себе
* Можно работать с ним
* **[Показать класс](Classes/class-synergy.php)**

## Возможности класса

* `load` - Подгружает данные по форме
* `getData` - Возвращает JSON данных по форме
* `getUUID` - Возвращает UUID текущей формы
* `getValue` - Возвращает значение
* `setValue` - Устанавливает новое значение
* `getRowsCount` - Вернёт кол-во строк в динамической таблице
* `convertTable` - Конвертирует таблицу в читаемый вид
* `save` - Сохроняет данные по форме
* `api` - Выполняет API методы Synergy
* `curl` - Выполняет URL запрос

## Аргументы функций
`load`(**dataUUID `int or String`**)<br>
`getData`(void)<br>
`getUUID`(void)
<hr>
`getValue`(**componentID `String`**, **key `String`**)<br>
`getValue`(**componentID `String`**, **tableID `String`**, **lineNumber `Int`**, **key `String`**)
<hr>
`setValue`(**componentID `String`**, **value `String or ArrayObject`**, **key `String`**)<br>
`setValue`(**componentID `String`**, **tableID `String`**, **lineNumber `Int`**, **value `String or ArrayObject`**, **key `String`**)
<hr>
`getRowsCount`(**tableID `String`**)<br>
`convertTable`(**tableID `String`**)<br>
`save`(void)<br>
`api`(**method `String`**, **type `String`**, **params `ArrayObject`**)<br>
`curl`(**url `String`**, **type `String`**, **params `ArrayObject`**, **&data `var`**)

## Примеры использования

>Подключение класса из вне (файлом)

```php
    require_once('class-synergy.php');
```

>Создаем класс

```php
    $synergy = new synergy();
    /**
     * =======================================
     * Указываем с каким хостом будем работать
     * =======================================
     */
    $synergy->host = 'https://synergy.arta.pro';
    /**
     * ==============================================================================================
     * Устанавливаем логин и пароль супер-пользователя или обычного пользователя с кем будем работать.
     * В другом варианте можно использовать класс на 1 пользователя *ниже*
     * ==============================================================================================
     */
    synergy::$host = 'https://synergy.arta.pro';
    synergy::$SU = '1:1';
```

>Получить значение компонента или компонента в дин.таблице

```php
synergy::load(dataUUID);
synergy::getValue('Название компонента');
synergy::getValue('Название компонента','Ключ');

synergy::getValue('Название компонента','Название таблицы','Номер строки','Ключ');
```

>Изменить значение компонента или компонента в дин.таблице

```php
synergy::load(dataUUID);
synergy::setValue('Название компонента','Значение'); // Изменит текст компонента
synergy::setValue('Название компонента','Значение','Ключ');
synergy::setValue('Название компонента',array(
    'key1' => 'value1',
    'key2' => 'value2'
));
synergy::setValue('Название компонента','Название таблицы','Номер строки','Значение или объект','Ключ');
```

>Работа с api методами

```php
$uuid = 1337;
/**
 * ============
 * GET - запрос
 * ============
 */
$data = synergy::api('asforms/data/' . $uuid);

/**
 * =============
 * POST - запрос
 * =============
 */
synergy::api('asforms/data/save','POST',array(
    'uuid' => $uuid,
    'data' => '"data":' . json_encode($data['data']);
));
```

>Конвертировать таблицу

```php
synergy::load(dataUUID);
synergy::convertTable('Название таблицы');
```