# Мобильная адаптивность формы Synergy через проигрыватель форм

**Библиотека:** [`library` Посмотреть код](Library/mobile_adaptability_form.js)

**Стили для библиотеки:** [`css` Посмотреть код стилей](Library/mobile_adaptability_form.css)

**Пример HTML структуры:** [`html` Посмотреть код верстки](Library/mobile_adaptability_form.html)

**Готовый шаблон:** [`Teamplate` Шаблон использования](Library/mobile_adaptability_form_teamplate.js)

**Автор:** [Антонович Сергей (yandexphp)](mail:antonovich_1313@mail.ru)

`System GUI | UI` - Это означает то, что у каждой мобильной платформы `Android`, `Microsoft`, `iPhone` и.т.д.<br>
Будет свой стиль отрисовки: выбора элемента из списка или же выбор даты.

* Заголовок компонента - `id_cmp` и прибавить приставку `label` а сам компонент (не текст) должен быть назван `id_cmp`
* Заголовок `id_cmp` и прибавить приставку `title`
* Подробнее в самом низу после скриншотов.

## Пример использования

```javascript
'use strict';

var PLAYER_PARENT_HANDLER = '#form_player_div';

var portal = {
    player : null,
    clearPlayer : function() {
        if(portal.player) {
            portal.player.destroy();
        }
    },
    createPlayer: function(){
        portal.clearPlayer();
        portal.player = AS.FORMS.createPlayer();
        /**
         * сюда вставить нашу либу
         */
        portal.player.view.setEditable(true);
        portal.player.showFormByCode('mobile-modal-window-form');
        portal.player.view.appendTo($(PLAYER_PARENT_HANDLER));
    }
};

$(function(){
    AS.OPTIONS.locale = "ru";
    AS.OPTIONS.coreUrl = FORM_PLAYER_URL_PREFIX;
    AS.OPTIONS.login = "login|$session|$key";
    AS.OPTIONS.password = "password|key|token";
    portal.createPlayer();
});
```

## Скриншоты

**`Как будет выглядеть форма:`**

![Результат](Library/e775eeb0-5979-4907-9eb9-b48fe559613e.jpeg)

**`Обязательные поля или маска:`**

![Результат](Library/91e1f82d-3319-4339-88f6-4a8c4125ed4a.jpeg)

**`Выбор элемента из списка:`** `System GUI | UI`

![Результат](Library/f48ace25-f344-4c60-9b1f-d82b0db1bbab.jpeg)

**`Выбор даты из пикера:`** `System GUI | UI`

![Результат](Library/d2404e39-cfb9-410b-8380-4e92f08e630c.jpeg)

![Описание](Library/Снимок_экрана_от_2018-10-23_12-45-07.png)