В проекте исходники для [презентации](blocking.pdf) на тему *Блок-процесс с нуля: интерпретатор + java*


# Инструкция по использованию

1. Остановить jboss

    ```
     # /etc/init.d/arta-synergy-jboss stop
    ```

2. Результат сборки `build/libs/blocking.war` положить в `/opt/synergy/jboss/standalone/deployments`

3. Создать очередь JMS для блокирующего процесса. 
   Для этого необходимо в конфигурационный файл 
   (в стандартной установке это `/opt/synergy/jboss/standalone/configuration/standalone-onesynergy.xml`) 
   в секцию <subsystem xmlns="urn:jboss:domain:messaging:1.2"> раздел `<jms-destinations>` добавить:

    ```xml
    <jms-queue name="TestBlockQueue">
        <entry name="queue/TestBlockQueue"/>
        <entry name="java:jboss/queues/Synergy/TestBlockQueue"/>
        <durable>true</durable>
    </jms-queue>
    ```

4. Связать очередь и процесс через конфигурационный файл `/opt/synergy/jboss/standalone/configuration/arta/api-observation-configuration.xml`, 
   добавив в него следующее:
   
    ```xml
    <listener>
        <queue>java:jboss/queues/Synergy/TestBlockQueue</queue>
        <event>event.blocking.test.*</event>
    </listener>
    ```
    
    Если конфигурационного файла `api-observation-configuration.xml` нет, то необходимо его создать и указать владельца:
   
    ```
     # chown jboss:synergy api-observation-configuration.xml
    ```
   
    Его содержимое должно быть следующим:
   
    ```xml
     <?xml version="1.0"?>
     <configuration>
        <listener>
            <queue>java:jboss/queues/Integration/InterpreterQueue</queue>
            <event>event.blocking.interpreter.*</event>
        </listener>
        <listener>
            <queue>java:jboss/queues/Synergy/TestBlockQueue</queue>
            <event>event.blocking.test.*</event>
        </listener>
     </configuration>
    ```

5. Создать файл в `/opt/synergy/jboss/standalone/configuration/arta/apps/test_blocking/test.properties`,
   добавив в него следующее:

   ```
   user.login=user_api
   user.password=user_api_password
   synergy.address=http://127.0.0.1:8080/Synergy
   ```

   Здесь user.login и user.password - логин и пароль пользователя, от имени которого будут выполняться вызовы api к
   Synergy. Указывать нужно логин и пароль пользователя Вашего экземпляра Synergy.

6. Запустить jboss

    ```
     # /etc/init.d/arta-synergy-jboss start
    ```

7. В маршруте реестра добавить блокирующий процесс `event.blocking.test.blocking.3`


# Приложение Synergy с конфигурацией объектов

В папке `src/main/resources/application` содержатся файлы с описанием и объектами
приложения `Test blocking process`

Чтобы выполнить импорт приложения в свой экземпляр Synergy, необходимо поместить содержимое папки
`application` в архив с форматом 7zip и в Synergy IDE в меню ``Приложение`` нажать на ``Импорт...``,
где выбрать созданный архив.
