package kz.arta.test.blocking;

import kz.arta.test.blocking.data.ASFData;
import kz.arta.test.blocking.data.ASFDataWrapperExt;
import kz.arta.test.blocking.utils.AsfDataApi;
import kz.arta.test.blocking.utils.DictApi;
import kz.arta.test.blocking.utils.PropsUtil;
import kz.arta.test.blocking.utils.UnblockOperation;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;

/**
 * User: Aigul
 * Date: 10.05.18
 * Time: 17:08
 */
@MessageDriven(name = "TestBlockQueue", activationConfig = {
        @ActivationConfigProperty(propertyName = "destinationType", propertyValue = "javax.jms.Queue"),
        @ActivationConfigProperty(propertyName = "destination", propertyValue = "java:jboss/queues/Synergy/TestBlockQueue"),
        @ActivationConfigProperty(propertyName = "reconnectAttempts", propertyValue = "32"),
        @ActivationConfigProperty(propertyName = "reconnectInterval", propertyValue = "4000"),
        @ActivationConfigProperty(propertyName = "acknowledgeMode", propertyValue = "Auto-acknowledge") })
public class BlockProcessListener implements MessageListener {

    private static final Logger LOGGER = LoggerFactory.getLogger(BlockProcessListener.class);

    private static final ObjectMapper REGULAR_MAPPER = new ObjectMapper();

    private static final String EVENT_STATUS = "event.blocking.test.blocking";

    @Override
    public void onMessage(Message message) {
        String executionID = null;
        boolean success = false;
        String resultMessage = null;
        try {
            String event = message.getStringProperty("api_event");
            LOGGER.error(event);
            JsonNode node = REGULAR_MAPPER.readTree(((TextMessage) message).getText());
            String dataUUID = node.get("dataUUID").asText();
            String documentID = node.get("documentID").asText();
            executionID = node.get("executionID").asText();

            success = true;

            if (event.startsWith(EVENT_STATUS)) {
                AsfDataApi asfDataApi = new AsfDataApi(PropsUtil.getAddress(), PropsUtil.getAuthEncoded());

                /*получаем данные по форме*/
                ASFDataWrapperExt data = asfDataApi.getAsfData(dataUUID);
                /*получаем данные выпадающего списка*/
                ASFData.Data listbox = data.getData("listbox-test");
                ASFData.Data textbox = data.getData("textbox");

                String statusKey = event.substring(EVENT_STATUS.length() + 1);

                listbox.setKey(statusKey);
                String statusValue = getDictStatusValue(statusKey);
                if (statusValue != null) {
                    listbox.setValue(statusValue);
                }

                if ("1".equals(textbox.getValue())) {
                    success = false;
                }

                /*сохранить сами данные по форме*/
                asfDataApi.saveData(REGULAR_MAPPER.writeValueAsString(data.getData()), data.getForm(), data.getUuid(), null);
            }

        } catch (Exception exc) {
            LOGGER.error("Error processing text message", exc);
        } finally {
            if (executionID != null) {
                if (resultMessage == null) {
                    resultMessage = success ? "OK" : "Error";
                }
                try {
                    UnblockOperation unblockOperation = new UnblockOperation(PropsUtil.getAddress(), PropsUtil.getAuthEncoded());
                    unblockOperation.unblock(executionID, resultMessage, success ? "got_agree" : "got_refuse");
                } catch (Exception e) {
                    LOGGER.error(e.getMessage(), e);
                }
            }
        }
    }


    /**
     * Получить название статуса
     * @param statusKey ключ статуса
     * @return
     * @throws Exception
     */
    private String getDictStatusValue(String statusKey) throws Exception {
        DictApi dictApi = new DictApi(PropsUtil.getAddress(), PropsUtil.getAuthEncoded());
        JsonNode values = REGULAR_MAPPER.readTree(dictApi.getDict("test_statuses", false, "ru")).get("items");
        for (JsonNode node : values) {
            JsonNode key = node.get("key");
            JsonNode value = node.get("value");
            if (statusKey != null && statusKey.equalsIgnoreCase(key.get("value").getTextValue())) {
                return value.get("translation").getTextValue();
            }
        }
        return null;
    }

}
