package kz.arta.test.blocking.data;

import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * User: vsl
 * Date: 3/18/15
 * Time: 9:48 AM
 * 
 * Утилиты для работы с данными форм 
 */
public class ASFDataUtils {
    private static final Pattern BLOCK_ID_PATTERN = Pattern.compile("(.*)-b([0-9]{1,})$");

    /**
     * Есть ли табличный индекс в id 
     */
    public static boolean hasBIndex(String id) {
        return BLOCK_ID_PATTERN.matcher(id).matches();
    }

    /**
     * Возвращает табличный индекс из id, если его нет - null
     */
    public static String getBindex(String id) {
        Matcher matcher = BLOCK_ID_PATTERN.matcher(id);
        if (!matcher.matches()) {
            return null;
        } else {
            return matcher.group(2);
        }
    }

    public static String generateTableBlockIndex(String realId, int blockIndex){
        return realId+"-b"+blockIndex;
    }

    /**
     * Возвращает часть id без табличного индекса если он есть,
     * если нет - просто возвращает id 
     */
    public static String getBlockComponentId(String id) {
        Matcher matcher = BLOCK_ID_PATTERN.matcher(id);
        if (!matcher.matches()) {
            return id;
        } else {
            return matcher.group(1);
        }
    }

    /**
     * Возвращает табличный индекс из id, если его нет -1
     */
    public static int getIntBindex(String id) {
        String bIndex = getBindex(id);
        if (bIndex == null || bIndex.isEmpty()) {
            return -1;
        }

        try {
            return Integer.parseInt(bIndex);
        } catch (NumberFormatException e) {
            return -1;
        }
    }

    public static void mergeAsfData(List<ASFData.Data> dest, List<ASFData.Data> additional) throws IllegalArgumentException{
        if(additional == null) {
            return;
        }

        ASFData data = new ASFData();
        data.setData(dest);

        for(ASFData.Data toAdd : additional) {
            data.addData(toAdd);
        }
    }

    public static Set<Integer> getBlockNumbers(List<ASFData.Data> tableData){
        Set<Integer> list = new HashSet<>();
        for(ASFData.Data data : tableData) {
            int blockNumber = getIntBindex(data.getId());
            if(blockNumber > 0 ) {
                list.add(blockNumber);
            }
        }
        return list;
    }

    public static void addAppendableTableData(List<ASFData.Data> dest, String tableId, List<ASFData.Data> additionalTableData){
        ASFData.Data tableData = null;
        for(ASFData.Data d : dest) {
            if (tableId.equals(d.getId())) {
                tableData = d;
                break;
            }
        }



        if(tableData == null) {
            tableData = new ASFData.Data();
            tableData.setId(tableId);
            tableData.setType(WidgetType.appendable_table.name());
            dest.add(tableData);
        }

        int lastIndex = tableData.getLastBlockNumber();

        for(ASFData.Data data : tableData.getDataCheckNull()) {
            lastIndex = Math.max(getIntBindex(data.getId()), lastIndex);
        }

        Map<Integer, Integer> tableNewIndices = new HashMap<>(); // map в который мы запоминаем каким блокам какие номера присвоены

        // генерируем новые номера блоков
        for(ASFData.Data data : additionalTableData) {
            int blockIndex = getIntBindex(data.getId());
            if (!tableNewIndices.containsKey(blockIndex)) {
                tableNewIndices.put(blockIndex, ++lastIndex);
            }
        }


        for(ASFData.Data data : additionalTableData) {

            int currentIndex = getIntBindex(data.getId());
            int newIndex = tableNewIndices.get(currentIndex);

            String cmpId = getBlockComponentId(data.getId());
            data.setId(generateTableBlockIndex(cmpId, newIndex));

            tableData.addData(data);
        }
    }





    /**
     * этот и следующие 5 методов используются в сторонних проектах. не удалять!.
     */
    public static ASFData.Data addData(String id, WidgetType type, ASFData.Data parent, String key, String value) {
        return addData(id, type, parent.getData(), key, value);
    }

    public static ASFData.Data addData(String id, WidgetType type, List<ASFData.Data> datas, String key, String value) {
        ASFData.Data data = new ASFData.Data();
        data.setId(id);
        data.setType(type.name());
        data.setValue(value);
        data.setKey(key);
        datas.add(data);
        return data;
    }

    public static ASFData.Data addData(String id, WidgetType type, ASFDataWrapper parent, String key, String value) {
        return addData(id, type, parent.getData(), key, value);
    }

    public static ASFData.Data getCmpData(ASFDataWrapper asfData, WidgetType type, String cmpID) {
        ASFData.Data data = asfData.getData(cmpID);
        if (data == null) {
            data = addData(cmpID, type, asfData.getData(), null, null);
            if (type == WidgetType.appendable_table) {
                data.setData(new ArrayList<ASFData.Data>());
            }
        }
        return data;
    }

    public static void setData(String id, WidgetType type, ASFData.Data reserveTable, String key, String value) {
        ASFData.Data data = reserveTable.getData(id);
        if (data == null) {
            data = addData(id, type, reserveTable, null, null);
        }
        data.setValue(value);
        data.setKey(key);
    }

    public static void setData(String id, WidgetType type, ASFDataWrapper reserveTable, String key, String value) {
        ASFData.Data data = reserveTable.getData(id);
        if (data == null) {
            data = addData(id, type, reserveTable, null, null);
        }
        data.setValue(value);
        data.setKey(key);
    }
 }
