package kz.arta.test.blocking.data;

import org.codehaus.jackson.annotate.JsonIgnoreProperties;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by val
 * Date: 15.05.2013
 * Time: 12:40
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class ASFDataWrapper {

    private String nodeUUID;
    private String uuid;
    private String form;
    private Integer formVersion;
    private String modified;
    private List<ASFData.Data> data;

    public String getUuid() {
        return uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String getForm() {
        return form;
    }

    public void setForm(String form) {
        this.form = form;
    }

    public Integer getFormVersion() {
        return formVersion;
    }

    public void setFormVersion(Integer formVersion) {
        this.formVersion = formVersion;
    }

    public String getModified() {
        return modified;
    }

    public void setModified(String modified) {
        this.modified = modified;
    }

    public List<ASFData.Data> getData() {
        return data;
    }

    /**
     * Возвращает данные компонента по его идентификатору. Не осуществляет поиск внутри динамической таблицы.
     * @param cmpID идентификатор компонента формы
     * @return данные компонента
     */
    public ASFData.Data getData(String cmpID) {
        if (data != null) {
            for (ASFData.Data d : data) {
                if (d.getId().equalsIgnoreCase(cmpID))
                    return d;
            }
        }
        return null;
    }

    /**
     * Возвращает данные компонента по его идентификатору. Осуществляет поиск внутри динамической таблицы.
     * @param cmpID идентификатор компонента формы
     * @param searchInsideTables искать внутри динамической таблицы
     * @return данные компонента
     */
    public ASFData.Data getData(String cmpID, boolean searchInsideTables) {
        if (!searchInsideTables)
            return getData(cmpID);
        if (data != null) {
            for (ASFData.Data d : data) {
                if (d.getData() != null && d.getData().size() > 0) {
                    for (ASFData.Data innerData : d.getData())
                        if (innerData.getId().equalsIgnoreCase(cmpID))
                            return innerData;
                } else if (d.getId().equalsIgnoreCase(cmpID))
                    return d;
            }
        }
        return null;
    }

    public List<ASFData.Data> getAllDataById(String cmpID, boolean includeDynamic) {
        List<ASFData.Data> result = new ArrayList<>();
        for (ASFData.Data data : this.data) {
            if(data == null ) {
                continue;
            }
            if (cmpID.equals(data.getId())) {
                result.add(data);
            }
            if(includeDynamic && data.getData() != null) {
                for(ASFData.Data dynData : data.getData()) {
                    if (cmpID.equals(ASFDataUtils.getBlockComponentId(dynData.getId()))) {
                        result.add(dynData);
                    }
                }
            }
        }
        return result;
    }

    public void setData(List<ASFData.Data> data) {
        this.data = data;
    }

    public String getNodeUUID() {
        return nodeUUID;
    }

    public void setNodeUUID(String nodeUUID) {
        this.nodeUUID = nodeUUID;
    }

    @Override
    public boolean equals(Object obj) {
        if(! (obj instanceof ASFDataWrapper)) return false;

        ASFDataWrapper data = (ASFDataWrapper) obj;

        for(ASFData.Data d : data.getData()){
            String id = d.getId();
            ASFData.Data d1 = getData(id);

            boolean equals = equalsData(d, d1);
            if(!equals) return false;

        }



        for(ASFData.Data d : getData()){
            String id = d.getId();
            ASFData.Data d1 = data.getData(id);

            boolean equals = equalsData(d, d1);
            if(!equals) return false;

        }

        return true;
    }

    private boolean equalsData(ASFData.Data d, ASFData.Data d1){
        if(d1==null
                || !equals(d1.getValue(), d.getValue())
                || !equals(d1.getKey(), d.getKey())
                || !equals(d1.getKeys(), d.getKeys())
                || !equals(d1.getValues(), d.getValues())
                ) {
            return false;
        }

        if(d.getData()!=null && d1.getData()!=null) {
            for (ASFData.Data childData : d.getData()) {
                ASFData.Data childData1 = d1.getData(childData.getId());
                boolean equals = equalsData(childData, childData1);
                if (!equals) return false;
            }
        }
        return true;
    }

    /**
     * заменяет данные с одинаковыми id на данные из mixin
     */
    public void mixin(List<ASFData.Data> mixin) {
        if (mixin == null)
            return;

        Map<String, ASFData.Data> idsMap = new HashMap<>();
        for (ASFData.Data data : mixin) {
            String id = data.getId();
            if (id == null || id.isEmpty())
                continue;
            idsMap.put(id, data);
        }

        List<ASFData.Data> mixed = new ArrayList<>();

        for (ASFData.Data data : this.data) {
            if (idsMap.containsKey(data.getId()))
                mixed.add(idsMap.get(data.getId()));
            else
                mixed.add(data);
        }

        this.data = mixed;
    }

    public static boolean equals(Object object1, Object object2) {
        return object1 == object2 ? true : (object1 != null && object2 != null ? object1.equals(object2) : false);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}
