package kz.arta.test.blocking.data;

/**
 * Created by IntelliJ IDEA.
 * User: exile
 * Date: 02.04.13
 * Time: 14:00
 * <br/><br/>
 * Перечисление типов компонентов формы.
 * Используется при получении списка компонентов формы.
 */
public enum WidgetType {
    label("FWLabel", false),
    textbox("FWText", true, true),
    textarea("FWTextArea", true, true),
    listbox("FWListBox", true, true),
    /**
     * Переключатель вариантов, сохранение ключа-значения реверсивное, в key - хранится значение, в value - ключ
     */
    radio("FWRadionList", true, true),
    /**
     * Выбор вариантов. Значения хранятся в массиве keys, ключи в массиве values. Key и value пустые
     */
    check("FWCheckList", true, true),
    date("FWDate", true, true),
    table("FWTable", false),
    entity("FWSynergyEntity", true, true),
    image("FWStaticImage", false),
    file("FWFileAttachment", false, true),
    filelink("FWFileLink", false, true),
    userchooser("FWUserChooser", true, true),
    counter("FWCounter"),
    signlist("FWSignList", false),
    resolutionlist("FWResolutionsList", false),
    htd("FWHtdEditor", true, true),
    doclink("FWSynergyDocLink", false, true),
    link("FWLink", true, true),
    processlist("FWProcessHistoryList", false),
    repeater("FWRepeatInput", true, true),
    reglink("FWSynergyRegLink", true, true),
    projectlink("FWSynergyProjLink", true, true),
    personlink("FWSynergyPersonLink", true, true),
    appendable_table("FWAppendableTable"),


    /**
     * пользовательский компонент
     */
    custom("FWCustom", true),



    /**
     * @deprecated - не используется
     */
    @Deprecated users("FWDUser"),
    departments("FWDepartmentChooser", true, true),
    positions("FWPositionChooser", true, true),
    docnumber("FWDocNumber", false)/* НА САМОМ ДЕЛЕ ЭТО СВОЙСТВА ДОКУМЕНТА*/,
    numericinput("FWNumericInput", true, true),
    errorlabel("FWErrorLabel", false),
    page("FWDPage", false),






    ;

    /**
     * Говорит является ли компонент полем ввода,
     * а также содержит и хранит значение.
     */
    private final boolean input;

    /**
     * Может ли пользователь непосредственно изменять значение виджета 
     */
    private final boolean editable;

    /**
     * Имя класса которое используется для элемента
     */
    private final String className;

    WidgetType(String className) {
        this(className, true, false);
    }

    WidgetType(String className, boolean input) {
        this(className, input, false);
    }
    
    WidgetType(String className, boolean input, boolean editable) {
        this.input = input;
        this.className = className;
        this.editable = editable;
    }
    
    public String getClassName() {
        return className;
    }

    public boolean isInput() {
        return input;
    }

    public boolean isEditable() {
        return editable;
    }

    /**
     * Является ли строка типом widget-а
     *
     * @param widgetType - тип widget-a
     * @return - является/не является
     */
    public static boolean contains(String widgetType) {
        return getFromString(widgetType) != null;
    }

    /**
     * По названию enum возвращает его
     *
     * @param typeStr название enum
     * @return enum
     */
    public static WidgetType getFromString(String typeStr) {
        for (WidgetType type : values()) {
            if (type.name().equals(typeStr)) {
                return type;
            }
        }
        return null;
    }

    /**
     * по полю не возможна сортировка и оно не будет быть значащим содержимым, но может быть отображено в таблице
     * @return true
     */
    public boolean notSortingViewField(){
        return isInput() && this != WidgetType.appendable_table;
    }

    /**
     * надо ли загружать данные формы, чтобы узнать ее значения
     * @return true - да
     */
    public boolean shouldLoadDataToGetValue(){
        return this == WidgetType.doclink || this == WidgetType.filelink || this == WidgetType.table || this == WidgetType.check;
    }


}
