package kz.arta.test.blocking.utils;


import kz.arta.test.blocking.data.ASFDataWrapperExt;

import java.io.DataOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;

/**
 * User: Aigul
 * Date: 3/18/17
 * Time: 4:52 PM
 */
public class AsfDataApi extends ApiOperation {

    public AsfDataApi(String address, String auth) {
        super(address, auth);
    }

    public ASFDataWrapperExt getAsfData(String dataUUID) throws IOException{
        return getAsfData(dataUUID, 0);
    }

    public ASFDataWrapperExt getAsfData(String dataUUID, int version) throws IOException{
        HttpURLConnection connection = openGetConnection(new URL(address + "/rest/api/asforms/data/" + dataUUID + "?version=" + version),
                auth);
        return readResult(connection, ASFDataWrapperExt.class);
    }

    public String saveData(String data, String formId, String dataUUID, String eventProperties) throws IOException {
        HttpURLConnection connection = openPostConnection(new URL(address + "/rest/api/asforms/data/save"), auth,
                null, "application/x-www-form-urlencoded;charset=utf-8");
        DataOutputStream request = new DataOutputStream(connection.getOutputStream());
        request.writeBytes("formUUID=" + formId);
        request.writeBytes("&");
        request.writeBytes("uuid=" + dataUUID);
        request.writeBytes("&");
        request.writeBytes("data=\"data\":");
        request.write(URLEncoder.encode(data, "UTF-8").getBytes("UTF-8"));
        request.writeBytes("&");
        request.writeBytes("eventProperties=");
        if (eventProperties != null) {
            request.write(URLEncoder.encode(eventProperties, "UTF-8").getBytes("UTF-8"));
        }
        request.flush();
        request.close();
        return readResult(connection);
    }

    public String saveDataWithCode(String data, String formCode, String dataUUID, String eventProperties) throws IOException {
        HttpURLConnection connection = openPostConnection(new URL(address + "/rest/api/asforms/data/save"), auth,
                null, "application/x-www-form-urlencoded;charset=utf-8");
        DataOutputStream request = new DataOutputStream(connection.getOutputStream());
        request.writeBytes("formCode=" + URLEncoder.encode(formCode, StandardCharsets.UTF_8.name()));
        request.writeBytes("&");
        request.writeBytes("uuid=" + dataUUID);
        request.writeBytes("&");
        request.writeBytes("data=\"data\":");
        request.write(URLEncoder.encode(data, StandardCharsets.UTF_8.name()).getBytes(StandardCharsets.UTF_8.name()));
        request.writeBytes("&");
        request.writeBytes("eventProperties=");
        if (eventProperties != null) {
            request.write(URLEncoder.encode(eventProperties, StandardCharsets.UTF_8.name()).getBytes(StandardCharsets.UTF_8.name()));
        }
        request.flush();
        request.close();
        return readResult(connection);
    }

}
