package kz.arta.test.blocking.utils;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;

/**
 * User: Aigul
 * Date: 3/18/17
 * Time: 4:24 PM
 */
public class DictApi extends ApiOperation {

    public DictApi(String address, String auth) {
        super(address, auth);
    }

    public String getDict(String dictCode, boolean loadColumns, String locale) throws IOException {
        HttpURLConnection connection = openGetConnection(new URL(address + "/rest/api/dictionaries/"+ URLEncoder.encode(dictCode, StandardCharsets.UTF_8.name())+
                "?getColumns="+loadColumns+"&locale=" + locale), auth);
        return readResult(connection);
    }

}
