package kz.arta.test.blocking.utils;

import java.io.DataOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;

/**
 * User: Aigul
 * Date: 4/15/17
 * Time: 7:24 PM
 */
public class FormApiOperation extends ApiOperation {
    public FormApiOperation(String address, String auth) {
        super(address, auth);
    }

    public String getAsfDataUUID(String documentID) throws Exception {
        HttpURLConnection connection =  openGetConnection(new URL(address + "/rest/api/formPlayer/getAsfDataUUID?documentID=" + documentID), auth,
                "text/plain; charset=utf-8");
        return this.readResult(connection);
    }

    public String saveDataMultiPart(String data, String formId, String dataUUID, String eventProperties) throws IOException {
        HttpURLConnection connection = this.openPostConnection(new URL(this.address + "/rest/api/asforms/form/multipartdata"), this.auth, null,
                "application/x-www-form-urlencoded;charset=utf-8");
        DataOutputStream request = new DataOutputStream(connection.getOutputStream());
        request.writeBytes("form=" + formId);
        request.writeBytes("&");
        request.writeBytes("uuid=" + dataUUID);
        request.writeBytes("&");
        request.writeBytes("data=");
        request.write(URLEncoder.encode(data, "UTF-8").getBytes("UTF-8"));
        request.writeBytes("&");
        request.writeBytes("eventProperties=");
        if(eventProperties != null) {
            request.write(URLEncoder.encode(eventProperties, "UTF-8").getBytes("UTF-8"));
        }
        request.flush();
        request.close();
        return this.readResult(connection);
    }
}
