package kz.arta.test.blocking.utils;

import org.slf4j.Logger;

import javax.xml.bind.DatatypeConverter;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.Properties;

/**
 * User: Aigul
 * Date: 3/18/17
 * Time: 3:43 PM
 */
public class PropsUtil {

    public static final String PROP_FILE = "arta/apps/test_blocking/test.properties";

    public static final String SYNERGY_ADDRESS_KEY = "synergy.address";
    public static final String SYNERGY_LOGIN_KEY = "user.login";
    public static final String SYNERGY_PASSWORD_KEY = "user.password";


    private static final Logger LOGGER = org.slf4j.LoggerFactory.getLogger(PropsUtil.class);

    private static Properties properties;

    private static long lastUpdatedTime = -1l;

    private static PropsUtil baiConfigInstance = new PropsUtil();

    private PropsUtil() {

    }

    public static PropsUtil getInstance() {
        return baiConfigInstance;
    }


    /**
     * Получение относительного пути конфигурационного файла
     */
    private static String getConfFilePath(String relativePath) {
        return getCfgURL() + "/" + relativePath;
    }

    /**
     * поднимаем конфиг директорию
     *
     * @return
     */
    public static String getCfgURL() {
        String cfgDir = System.getProperty("jboss.server.config.url");
        if (cfgDir != null && cfgDir.startsWith("file://")) {
            try {
                URL url = new URL(cfgDir);
                return url.getFile();
            } catch (MalformedURLException e) {
                LOGGER.error(e.getMessage(), e);
            }
        }

        if (cfgDir == null) {
            cfgDir = System.getProperty("jboss.server.config.dir");
            if (cfgDir != null) {
                return cfgDir;
            } else {
                LOGGER.error("NOT FOUND CONFIG DIRECTORY");
                return "/home/conf";
            }
        }
        return cfgDir;
    }

    public static String getProperty(String key) {
        return getProps(false).getProperty(key);
    }

    public static String get(String key) {
        return getProps(false).getProperty(key);
    }

    public static String getAddress() {
        return getProperty("synergy.address");
    }

    public static String getPassword() {
        return getProperty("user.password");
    }

    public static String getLogin() {
        return getProperty("user.login");
    }

    private static String getAuthEncoded(String login, String password) {
        return DatatypeConverter.printBase64Binary((login + ":" + password).getBytes());
    }

    public static String getAuthEncoded() {
        String login = getLogin();
        String password = getPassword();

        return "Basic " + DatatypeConverter.printBase64Binary((login + ":" + password).getBytes());
    }

    /**
     * Настройки
     */
    public static Properties getProps(boolean updateCache) {

        long diffMinutes = (new Date().getTime() - lastUpdatedTime) / (60 * 1000);
        if (!updateCache && lastUpdatedTime > 0 && diffMinutes < 15 && properties != null) {
            return properties;
        }
        if (properties != null)
            return properties;

        properties = new Properties();
        try {

            File file = new File(getConfFilePath(PROP_FILE));
            if (file.exists()) {
                LOGGER.debug("Reading settings from " + file.getAbsolutePath());
                properties.load(new InputStreamReader(new FileInputStream(file), "UTF-8"));
            } else {
                properties = null;
                LOGGER.debug("File " + file.getAbsolutePath() + " does not exist!");
            }
        } catch (Exception exc) {
            properties = null;
            LOGGER.error(exc.getMessage(), exc);
        }
        return properties;
    }

}
