#Корзина

![Демонстрация](basket.webm)

**Автор:** [Адамович Евгений](mailto:e.adamovich@arta.pro)

Для импорта в конструктор:
[Исходники](../../constructor/basket/basket.json)\
Для импорта в синержди:
[Конфигурация](../../constructor/basket/app-basket2019-07-17_05-22-13.7zip)

Дополнительно:\
В SynergyAdmin создать юзера `Гость` с авторизацией: логин `_guest`, пароль `123456`

###Описание

**Корзина** - сложный компонент, состоит из 5 пользовательских компонентов, взаимодействующих между собой:
* `Корзина - кнопка` - почти на кажой странице в заголовке есть кнопка с изображением корзины, клик по кнопке перенаправляет на страницу корзиной `page_basket`, после каждого обновления страницы подтягивает куки и считывает количество покупок, если больше нуля - поверх корзины появляется зеленый индикатор с количеством покупок
* `Аккордион - категории` - отображает категории товаров, поведение после клика на категорию меняется:
    * На странице магазина `page_shop` - передает компоненту с кодом `shop` UUID категории
    * На других страницах - записывает в сессионые куки UUID категории и перенаправляет на страницу магазина `page_shop`
* `Аккордион - магазин` - каждая покупка меняет куки `basket`, инициализируется 2 способами:
    * После каждого получения store срабатывает событие `change_custom_comp_store` и компонент обновляет содержимое
    * При инициализации ищет куки с UUID категории, если нашел - отобразит список товаров связанных с этой категорией, иначе выведет отобразит сообщение "выберите категорию"
* `Корзина - список` - при инициализации ищет куки `basket`, если нашел - отобразит содержимое, иначе отобразит сообщение "Ваша корзина пуста"
* `Мои договора` - ищет договора связанные только с текущим пользователем и отображает в виде списка, если не нашел - отобразит сообщение "Вы не заключили ни одного договора"

**Мини-компоненты** - компоненты, входящие в состав других пользовательских компонентов
* Числовой регулятор `num_btn`, параметры: value, opt, onchange, onadd, onsub
    * value (число) - начальное значение
    * opt (объект) = {width:numeric, max:numeric, min:numeric} - дополнительные параметры
    * onchange (функция) - срабатывает после каждого обновления value
    * onadd (функция) - срабатывает после каждого инкремента через клик по кнопке `+`;
    * onsub (функция) - срабатывает после каждого декремента через клик по кнопке `-`.
* Вычисляемое поле `calc_field`, параметры: value, opt
    * value (число, строка, массив, объект) - начальное значение, примеры:
        * Число: 5, 4.40, "23";
        * Строка: "23\*12", "2+2\*2", "14\*(5+12)";
        * Массив: [3,5,6], ["3",23,"12"];
        * Объект: {a:3,b:5,c:6},{a:"3",b:23,c:"12"};
    * opt (объект) = {pre:string, op:string after:string} - дополнительные параметры
        * pre - строка перед итоговым числом;
        * after - строк после итогового числа;
        * op - символ-математическая или побитовая операция для массива чисел: \*, +, -, /, %, &, |, ^.

###Функционал, которого не хватет
1. Файл в ресурсах other-login.js\
    1.1. Клик на кнопку с кодом `btn-contarct-auth` - нужно дописать алгоритм: авторизация -> создание записи в реестре договора -> переход на страницу договоров\
    1.2. Клик на кнопку с кодом `btn-accept` - дописать алгоритм: выполнить апи создания юзера -> перейти на страницу авторизации или сразу авторизовать под новым юзером
2. Взаимодействие с реестром `Корзина`\
    2.1. После авторизации выполнить алгоритм: поиск неактивированной записи в реестре `Корзина` -> если не нашел - создать новую и вложить туда содержимое куки, иначе синхронизировать данные между записью и куки\
    2.2. Защита от большого количества запросов на создание/пересохранение записи
3. Возможность авторизоваться с любой страницы, и авторизация в качестве гостя (выход с аккаунта)
4. ПК `Мои договора`\
    4.1. Для тегов \<a\> на событие клик передать функцию, в которую передается UUID договора для вызова asforms/data/get\
    4.2. Возможность не только отображать список договоров, но и после клика на договор отобразить соответствующие данные, полученные из пункта 4.1, здесь же и кнопку "Назад", чтобы вернуться к списку договоров
5. ПК `Корзина - кнопка` - обновлять количество покупок в режиме реального времени
6. У числового регулятора нет защиты на случай когда opt.min>opt.max