package kz.arta.synergy.api.services;

import kz.arta.synergy.api.JsonUtils;
import kz.arta.synergy.api.Query;
import kz.arta.synergy.api.QueryContext;
import kz.arta.synergy.api.RestHttpQuery;
import kz.arta.synergy.api.pojo.SynergyWork;

import java.io.IOException;

/**
 * @author raimbek
 * @since 14.11.2016
 */
public class WorkflowService {

    private final RestHttpQuery restHttpQuery;

    private WorkflowService(QueryContext context) {
        this.restHttpQuery = new RestHttpQuery(context);
    }

    public static WorkflowService newInstance(QueryContext queryContext) {
        return new WorkflowService(queryContext);
    }

    public String createWork(SynergyWork work) throws IOException {
        Query query = Query.newInstance()
                .methodPost()
                .url("/rest/api/workflow/work/create")
                .formParam("name", work.getName())
                .formParam("startDate", work.getStartDate())
                .formParam("finishDate", work.getFinishDate())
                .formParam("priority", work.getPriority())
                .formParam("authorID", work.getAuthorID())
                .formParam("resUserID", work.getResUserID());
        return restHttpQuery.doQuery(query);
    }

    public String getWorkDocumentId(String workId) throws IOException {
        return JsonUtils.getValueByKey(restHttpQuery.doQuery("/rest/api/workflow/work/" + workId + "/document"), "documentID");
    }

    public String deleteWork(String workId) throws IOException {
        return restHttpQuery.doQuery("/rest/api/workflow/work/delete?workID=" + workId);
    }
}
