package kz.arta.synergy.api.asforms.converter;

import kz.arta.synergy.api.asforms.converter.components.ComponentConverter;
import kz.arta.synergy.api.asforms.pojo.AsForm;
import kz.arta.synergy.api.asforms.pojo.AsFormDataContainer;
import kz.arta.synergy.api.asforms.pojo.AsFormWrapper;

import java.lang.annotation.Annotation;

/**
 * Интерфейс для конверторов данных форм к объектам и обратно.
 * Реализация этого интерфейса должен обеспечивать конвертацию
 * данных из {@link AsFormDataContainer} на обычный java объект.
 * А так же конвертацию из {@link AsForm} на {@link AsFormDataContainer}.
 *
 * @author raimbek
 * @since 11.11.2016
 */
public interface AsFormConverter {

    /**
     * Конвертация с {@link AsForm} на {@link AsFormWrapper}.
     * В основном используется перед отправкой данных на synergy, т.е.
     * сохранение.
     *
     * @param asForm    объект формы
     * @param <T>   тип должен быть наследником {@link AsForm}
     * @return данные формы в фиде {@link AsFormWrapper}
     */
    <T extends AsForm> AsFormWrapper toAsfData(T asForm);

    /**
     * Метод чтобы конвертировать объекты таблицы. Должен повторят
     * поведение AsFormConverter#toAsfData(AsForm) но с учетом
     * индекса (-b1, -b2).
     * @see AsFormConverter#toAsfData(AsForm)
     */
    <T> AsFormDataContainer toAsfData(T asForm, String index);

    /**
     * Конвертация данных из {@link AsFormDataContainer} на java
     * объект
     *
     * @param asFormClass   тип объекта, который надо создать
     * @param asfData   данные
     * @param <T>   тип должен быть наследником {@link AsForm}
     * @return  java объект, созданный на основе данных форм
     */
    <T extends AsForm> T toAsForm(Class<T> asFormClass, AsFormWrapper asfData);

    /**
     * Повторяет поведение метода {@link #toAsForm(Class, AsFormWrapper)}
     * но для динамической таблицы. Учитывает индексы.
     */
    <T> T toAsForm(Class<T> asFormClass, AsFormDataContainer asfData, String index);

    /**
     * Предполагается для конвертаций отдельных данных (полей, компонентов)
     * использутся отдельные конверторы. Конечно, можно обойтись без них,
     * но полагается без них класс конвертора будет просто огромным. Для
     * регистраций таких конверторов используется этот метод.
     * @param annotation    аннотация компонента
     * @param converter     сам конвертор
     */
    void registerConverter(Class<? extends Annotation> annotation, ComponentConverter converter);
}
