package kz.arta.synergy.api.asforms.converter;

import kz.arta.synergy.api.asforms.annotations.*;
import kz.arta.synergy.api.asforms.converter.components.*;
import kz.arta.synergy.api.asforms.exceptions.CreateAsFormException;
import kz.arta.synergy.api.asforms.pojo.AsForm;
import kz.arta.synergy.api.asforms.pojo.AsFormData;
import kz.arta.synergy.api.asforms.pojo.AsFormDataContainer;
import kz.arta.synergy.api.asforms.pojo.AsFormWrapper;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

/**
 * Конвертор данных используемый по умолчанию
 *
 * @author raimbek
 * @since 11.11.2016
 */
public class DefaultAsFormConverter implements AsFormConverter {

    Map<Class<? extends Annotation>, ComponentConverter> componentConverters = new HashMap<>();

    public DefaultAsFormConverter() {
        registerConverter(Cmp.class, new CommonConverter());
        registerConverter(TextBox.class, new TextBoxConverter());
        registerConverter(NumericInput.class, new NumericInputConverter());
        registerConverter(Entity.class, new EntityConverter());
        registerConverter(ListBox.class, new ListBoxConverter());
        registerConverter(Table.class, new TableConverter(this));
    }

    @Override
    public <T extends AsForm> AsFormWrapper toAsfData(T asForm) {
        AsFormWrapper asFormWrapper = new AsFormWrapper();
        asFormWrapper.setForm(asForm.getForm());
        asFormWrapper.setModified(asForm.getModified());
        asFormWrapper.setNodeUUID(asForm.getNodeUUID());
        asFormWrapper.setUuid(asForm.getUuid());
        asFormWrapper.setData(toAsfData(asForm, null).getData());
        return asFormWrapper;
    }

    @Override
    public <T> AsFormDataContainer toAsfData(T asForm, String index) {
        AsFormDataContainer dataContainer = new AsFormDataContainer();
        try {
            Field[] allFields = asForm.getClass().getDeclaredFields();
            for (Field field : allFields) {
                field.setAccessible(true);
                Object o = field.get(asForm);
                if (o == null) {
                    continue;
                }
                Annotation[] declaredAnnotations = field.getDeclaredAnnotations();
                for (Annotation annotation : declaredAnnotations) {
                    if (componentConverters.containsKey(annotation.annotationType())) {
                        ComponentConverter componentConverter = componentConverters.get(annotation.annotationType());
                        AsFormData data = componentConverter.toAsfData(asForm, field, annotation, index);
                        dataContainer.addData(data);
                        break;
                    }
                }
            }
        } catch (IllegalAccessException e) {
            throw new CreateAsFormException("Form class should be accessible");
        }
        return dataContainer;
    }

    @Override
    public <T extends AsForm> T toAsForm(Class<T> asFormClass, AsFormWrapper asfData) {
        T asForm = toAsForm(asFormClass, asfData, null);
        asForm.setForm(asfData.getForm());
        asForm.setModified(asfData.getModified());
        asForm.setNodeUUID(asfData.getNodeUUID());
        asForm.setUuid(asfData.getUuid());
        return asForm;
    }

    @Override
    public void registerConverter(Class<? extends Annotation> annotation, ComponentConverter converter) {
        componentConverters.put(annotation, converter);
    }

    @Override
    public <T> T toAsForm(Class<T> asFormClass, AsFormDataContainer asfData, String index) {
        try {
            T asFormObject = asFormClass.newInstance();
            if (asfData == null || asfData.getData() == null || asfData.getData().isEmpty()) {
                return asFormObject;
            }

            Field[] allFields = asFormClass.getDeclaredFields();
            for (Field field : allFields) {
                Annotation[] declaredAnnotations = field.getDeclaredAnnotations();
                for (Annotation annotation : declaredAnnotations) {
                    if (componentConverters.containsKey(annotation.annotationType())) {
                        ComponentConverter componentConverter = componentConverters.get(annotation.annotationType());
                        componentConverter.setFieldValue(asfData, asFormObject, field, annotation, index);
                        break;
                    }
                }
            }
            return asFormObject;
        } catch (InstantiationException e) {
            throw new CreateAsFormException("Form class should has accessible without params constructor");
        } catch (IllegalAccessException e) {
            throw new CreateAsFormException("Form class should be accessible");
        } catch (Exception e) {
            throw new CreateAsFormException(e);
        }
    }
}
