package kz.arta.synergy.api.asforms.utils;

import java.util.HashMap;
import java.util.Map;

public class SearchIndexParamsBuilder {

    private String form;

    private String term = "and";

    private Integer startRecord = null;

    private Integer recordsCount = null;

    private Boolean showDeleted = null;

    private Boolean searchInRegistry = null;

    private Map<String, String> typeExactParams = new HashMap<>();
    private Map<String, String> typePartialParams = new HashMap<>();

    private SearchIndexParamsBuilder() {
    }

    public static SearchIndexParamsBuilder newBuilder() {
        return new SearchIndexParamsBuilder();
    }

    public SearchIndexParamsBuilder form(String formId) {
        this.form = formId;
        return this;
    }

    public SearchIndexParamsBuilder termOr() {
        this.term = "or";
        return this;
    }

    public SearchIndexParamsBuilder showDeleted(boolean showDeleted) {
        this.showDeleted = showDeleted;
        return this;
    }

    public SearchIndexParamsBuilder searchInRegistry(boolean searchInRegistry) {
        this.searchInRegistry = searchInRegistry;
        return this;
    }

    public SearchIndexParamsBuilder startRecord(int startRecord) {
        this.startRecord = startRecord;
        return this;
    }

    public SearchIndexParamsBuilder recordsCount(int recordsCount) {
        this.recordsCount = recordsCount;
        return this;
    }

    public SearchIndexParamsBuilder exact(String field, String search) {
        typeExactParams.put(field, search);
        return this;
    }

    public SearchIndexParamsBuilder partial(String field, String search) {
        typePartialParams.put(field, search);
        return this;
    }

    public String build() {
        String params = "";
        params += searchParams(typeExactParams, "exact", 0);
        params += searchParams(typePartialParams, "partial", typeExactParams.size());

        params += getParam("startRecord", startRecord)
                + getParam("recordsCount", recordsCount)
                + getParam("showDeleted", showDeleted)
                + getParam("searchInRegistry", searchInRegistry)
                + getParam("term", term);

        params = params.substring(0, params.length() - 1);

        return params;
    }

    private String searchParams(Map<String, String> params, String type, int index) {
        String result = "";
        for (Map.Entry<String, String> entry : params.entrySet()) {
            String indexString = "";
            if (index != 0) {
                indexString = String.valueOf(index);
            }
            result += String.format(
                    "formUUID%s=%s&field%s=%s&search%s=%s&type%s=%s&",
                    indexString, form,
                    indexString, entry.getKey(),
                    indexString, entry.getValue(),
                    indexString, type
            );
            index++;
        }
        return result;
    }

    private String getParam(String name, Object value) {
        if (value == null || String.valueOf(value).isEmpty()) {
            return "";
        }
        return name + "=" + value + "&";
    }
}
