package kz.arta.synergy.api;

import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.codehaus.jackson.type.TypeReference;

import java.io.IOException;

public class JsonUtils {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    private JsonUtils() {

    }

    public static String toJson(Object object) throws IOException {
        MAPPER.setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
        return MAPPER.writeValueAsString(object);
    }

    public static JsonNode readTree(String content) throws IOException {
        return MAPPER.readTree(content);
    }

    public static ObjectMapper getMapper() {
        return MAPPER;
    }

    public static <T> T read(String result, Class<T> synResponseClass) throws IOException {
        MAPPER.setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
        return MAPPER.readValue(result, synResponseClass);
    }

    public static <T> T read(String result, TypeReference<T> typeReference) throws IOException {
        MAPPER.setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
        return MAPPER.readValue(result, typeReference);
    }

    public static String getValueByKey(String jsonData, String key) throws IOException {
        return MAPPER.readTree(jsonData).path(key).getTextValue();
    }

    public static String getValueByPath(String jsonData, String path) throws IOException {
        String[] pathArray = path.split("\\.");
        JsonNode jsonNode = MAPPER.readTree(jsonData);
        for (String pathItem : pathArray) {
            jsonNode = jsonNode.path(pathItem);
        }
        return jsonNode.getTextValue();
    }

}
