package kz.arta.synergy.api.asforms.pojo;

import org.codehaus.jackson.annotate.JsonIgnoreProperties;

/**
 * @author raimbek
 * @since 09.11.2016
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class AsFormWrapper extends AsFormDataContainer {
    private String nodeUUID;
    private String uuid;
    private String form;
    private String modified;
    private String version;

    public AsFormWrapper() {
    }

    public String getNodeUUID() {
        return nodeUUID;
    }

    public void setNodeUUID(String nodeUUID) {
        this.nodeUUID = nodeUUID;
    }

    public String getUuid() {
        return uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String getForm() {
        return form;
    }

    public void setForm(String form) {
        this.form = form;
    }

    public String getModified() {
        return modified;
    }

    public void setModified(String modified) {
        this.modified = modified;
    }

    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;

        AsFormWrapper that = (AsFormWrapper) o;

        if (nodeUUID != null ? !nodeUUID.equals(that.nodeUUID) : that.nodeUUID != null) return false;
        if (uuid != null ? !uuid.equals(that.uuid) : that.uuid != null) return false;
        if (form != null ? !form.equals(that.form) : that.form != null) return false;
        if (modified != null ? !modified.equals(that.modified) : that.modified != null) return false;
        boolean b = !(version != null ? !version.equals(that.version) : that.version != null);
        return b && super.equals(o);

    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (nodeUUID != null ? nodeUUID.hashCode() : 0);
        result = 31 * result + (uuid != null ? uuid.hashCode() : 0);
        result = 31 * result + (form != null ? form.hashCode() : 0);
        result = 31 * result + (modified != null ? modified.hashCode() : 0);
        result = 31 * result + (version != null ? version.hashCode() : 0);
        return result;
    }
}
