package kz.arta.synergy.api.services;

import kz.arta.synergy.api.JsonUtils;
import kz.arta.synergy.api.Query;
import kz.arta.synergy.api.QueryContext;
import kz.arta.synergy.api.RestHttpQuery;
import kz.arta.synergy.api.pojo.DocSend;
import kz.arta.synergy.api.pojo.DocumentInfo;
import kz.arta.synergy.api.pojo.SynergyDepartment;
import kz.arta.synergy.api.pojo.SynergyDepartmentContent;
import org.codehaus.jackson.type.TypeReference;

import java.io.IOException;
import java.util.List;

/**
 * @author raimbek
 * @since 14.11.2016
 */
public class DepartmentsService {

    private final RestHttpQuery restHttpQuery;

    private DepartmentsService(QueryContext context) {
        this.restHttpQuery = new RestHttpQuery(context);
    }

    public static DepartmentsService newInstance(QueryContext queryContext) {
        return new DepartmentsService(queryContext);
    }

    public SynergyDepartment getDepartment(String departmentId) throws IOException {
        Query query = Query.newInstance()
                .url("/rest/api/departments/get")
                .queryParam("departmentID", departmentId);
        return JsonUtils.read(restHttpQuery.doQuery(query), SynergyDepartment.class);
    }

    public SynergyDepartmentContent getDepartmentsContent(String departmentId, Boolean onlyPosition, Boolean onlyDepartments) throws IOException {
        Query query = Query.newInstance()
                .url("/rest/api/departments/content")
                .queryParam("onlyPosition", onlyPosition)
                .queryParam("onlyDepartments", onlyDepartments)
                .queryParam("departmentID", departmentId);
        return JsonUtils.read(restHttpQuery.doQuery(query), SynergyDepartmentContent.class);
    }

    public String saveDepartment(SynergyDepartment synergyDepartment) throws IOException {
        Query query = Query.newInstance()
                .url("/rest/api/departments/save")
                .methodPost()
                .formParam("nameRu", synergyDepartment.getNameRu())
                .formParam("nameKz", synergyDepartment.getNameKz())
                .formParam("nameEn", synergyDepartment.getNameEn())
                .formParam("positionNameRu", synergyDepartment.getManager().getNameRu())
                .formParam("positionNameKz", synergyDepartment.getManager().getNameKz())
                .formParam("positionNameEn", synergyDepartment.getManager().getNameEn())
                .formParam("pointersCode", synergyDepartment.getPointersCode())
                .formParam("number", synergyDepartment.getNumber())
                .formParam("departmentID", synergyDepartment.getDepartmentID())
                .formParam("parentDepartmentID", synergyDepartment.getParentDepartmentID());
        return restHttpQuery.doQuery(query);
    }

    public String deleteDepartment(String departmentId) throws IOException {
        Query query = Query.newInstance()
            .url("/rest/api/departments/delete")
            .queryParam("departmentID", departmentId);
        return restHttpQuery.doQuery(query);
    }

    public List<String> searchDepartmentsByPointerCode(String pointerCode) throws IOException {
        Query query = Query.newInstance()
                .url("/rest/api/departments/search")
                .queryParam("pointer_code", pointerCode)
                .queryParam("deleted", false);
        return JsonUtils.read(restHttpQuery.doQuery(query), new TypeReference<List<String>>() {});
    }
}
