package kz.arta.synergy.api.services;

import kz.arta.synergy.api.JsonUtils;
import kz.arta.synergy.api.Query;
import kz.arta.synergy.api.QueryContext;
import kz.arta.synergy.api.RestHttpQuery;
import kz.arta.synergy.api.pojo.SynergyPosition;
import org.codehaus.jackson.type.TypeReference;

import java.io.IOException;
import java.util.List;

/**
 * @author raimbek
 * @since 14.11.2016
 */
public class PositionsService {

    private final RestHttpQuery restHttpQuery;

    private PositionsService(QueryContext context) {
        this.restHttpQuery = new RestHttpQuery(context);
    }

    public static PositionsService newInstance(QueryContext queryContext) {
        return new PositionsService(queryContext);
    }

    public SynergyPosition getPosition(String positionId) throws IOException {
        Query query = Query.newInstance()
                .url("/rest/api/positions/get")
                .queryParam("positionID", positionId);
        return JsonUtils.read(restHttpQuery.doQuery(query), SynergyPosition.class);
    }

    public String savePosition(SynergyPosition position) throws IOException {
        Query query = Query.newInstance()
                .url("/rest/api/positions/save")
                .methodPost()
                .formParam("nameRu", position.getNameRu())
                .formParam("nameKz", position.getNameKz())
                .formParam("nameEn", position.getNameEn())
                .formParam("pointersCode", position.getPointersCode())
                .formParam("positionID", position.getPositionID())
                .formParam("departmentID", position.getDepartmentID())
                .formParam("positionType", position.getPositionType())
                .formParam("number", position.getNumber());
        return restHttpQuery.doQuery(query);
    }

    public List<String> searchPositionsByPointerCode(String code) throws IOException {
        Query query = Query.newInstance()
                .url("/rest/api/positions/search")
                .queryParam("pointer_code", code)
                .queryParam("deleted", false);
        return JsonUtils.read(restHttpQuery.doQuery(query), new TypeReference<List<String>>() {});
    }

    public String appointToPosition(String positionId, String userId) throws IOException {
        Query query = Query.newInstance()
                .url("/rest/api/positions/appoint")
                .queryParam("positionID", positionId)
                .queryParam("userID", userId);
        return restHttpQuery.doQuery(query);
    }

    public String dischargeFromPosition(String positionID, String personID) throws IOException {
        Query query = Query.newInstance()
                .url("/rest/api/positions/discharge")
                .queryParam("positionID", positionID)
                .queryParam("userID", personID);
        return restHttpQuery.doQuery(query);
    }

    public String deletePosition(String positionId) throws IOException {
        Query query = Query.newInstance()
                .url("/rest/api/positions/delete")
                .queryParam("positionID", positionId);
        return restHttpQuery.doQuery(query);
    }
}
