package kz.arta.synergy.api.pojo;

import org.codehaus.jackson.annotate.JsonIgnoreProperties;

/**
 * @author raimbek
 * @since 08.08.2016
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class SynergyPosition {
    private String positionID;
    private String departmentID;
    private String nameRu;
    private String nameKz;
    private String nameEn;
    private String parentDepartmentID;
    private String pointersCode;
    private String number;
    private String salary;
    private String vacancies;
    private String positionType;

    public SynergyPosition() {
    }

    public String getPositionID() {
        return positionID;
    }

    public void setPositionID(String positionID) {
        this.positionID = positionID;
    }

    public String getDepartmentID() {
        return departmentID;
    }

    public void setDepartmentID(String departmentID) {
        this.departmentID = departmentID;
    }

    public String getNameRu() {
        return nameRu;
    }

    public void setNameRu(String nameRu) {
        this.nameRu = nameRu;
    }

    public String getNameKz() {
        return nameKz;
    }

    public void setNameKz(String nameKz) {
        this.nameKz = nameKz;
    }

    public String getNameEn() {
        return nameEn;
    }

    public void setNameEn(String nameEn) {
        this.nameEn = nameEn;
    }

    public String getParentDepartmentID() {
        return parentDepartmentID;
    }

    public void setParentDepartmentID(String parentDepartmentID) {
        this.parentDepartmentID = parentDepartmentID;
    }

    public String getPointersCode() {
        return pointersCode;
    }

    public void setPointersCode(String pointersCode) {
        this.pointersCode = pointersCode;
    }

    public String getNumber() {
        return number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public String getSalary() {
        return salary;
    }

    public void setSalary(String salary) {
        this.salary = salary;
    }

    public String getVacancies() {
        return vacancies;
    }

    public void setVacancies(String vacancies) {
        this.vacancies = vacancies;
    }

    public String getPositionType() {
        return positionType;
    }

    public void setPositionType(String positionType) {
        this.positionType = positionType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        SynergyPosition that = (SynergyPosition) o;

        if (positionID != null ? !positionID.equals(that.positionID) : that.positionID != null) return false;
        if (departmentID != null ? !departmentID.equals(that.departmentID) : that.departmentID != null) return false;
        if (nameRu != null ? !nameRu.equals(that.nameRu) : that.nameRu != null) return false;
        if (nameKz != null ? !nameKz.equals(that.nameKz) : that.nameKz != null) return false;
        if (nameEn != null ? !nameEn.equals(that.nameEn) : that.nameEn != null) return false;
        if (parentDepartmentID != null ? !parentDepartmentID.equals(that.parentDepartmentID) : that.parentDepartmentID != null)
            return false;
        if (pointersCode != null ? !pointersCode.equals(that.pointersCode) : that.pointersCode != null) return false;
        if (number != null ? !number.equals(that.number) : that.number != null) return false;
        if (salary != null ? !salary.equals(that.salary) : that.salary != null) return false;
        if (vacancies != null ? !vacancies.equals(that.vacancies) : that.vacancies != null) return false;
        return !(positionType != null ? !positionType.equals(that.positionType) : that.positionType != null);

    }

    @Override
    public int hashCode() {
        int result = positionID != null ? positionID.hashCode() : 0;
        result = 31 * result + (departmentID != null ? departmentID.hashCode() : 0);
        result = 31 * result + (nameRu != null ? nameRu.hashCode() : 0);
        result = 31 * result + (nameKz != null ? nameKz.hashCode() : 0);
        result = 31 * result + (nameEn != null ? nameEn.hashCode() : 0);
        result = 31 * result + (parentDepartmentID != null ? parentDepartmentID.hashCode() : 0);
        result = 31 * result + (pointersCode != null ? pointersCode.hashCode() : 0);
        result = 31 * result + (number != null ? number.hashCode() : 0);
        result = 31 * result + (salary != null ? salary.hashCode() : 0);
        result = 31 * result + (vacancies != null ? vacancies.hashCode() : 0);
        result = 31 * result + (positionType != null ? positionType.hashCode() : 0);
        return result;
    }
}
